/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.types.DmcTypeEnumValue;
import org.dmd.dms.types.EnumValue;

public class DmcTypeEnumValueSET
extends DmcTypeEnumValue
implements Serializable {
    private static final Iterator<EnumValue> emptyList = new HashSet().iterator();
    protected Set<EnumValue> value;

    public DmcTypeEnumValueSET() {
        this.value = null;
    }

    public DmcTypeEnumValueSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<EnumValue>() : new TreeSet<EnumValue>();
    }

    public DmcTypeEnumValueSET getNew() {
        return new DmcTypeEnumValueSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<EnumValue> cloneIt() {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            DmcTypeEnumValueSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (EnumValue val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumValue add(Object v) throws DmcValueException {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            EnumValue rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumValue del(Object v) {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            EnumValue rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EnumValue> getMV() {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<EnumValue>(this.value).iterator();
            }
            return new TreeSet<EnumValue>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EnumValue> getMVCopy() {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<EnumValue>();
                }
                return new HashSet<EnumValue>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<EnumValue>(this.value);
            }
            return new TreeSet<EnumValue>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeEnumValueSET dmcTypeEnumValueSET = this;
        synchronized (dmcTypeEnumValueSET) {
            if (this.value == null) {
                return false;
            }
            try {
                EnumValue val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

