/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeField;
import org.dmd.dms.generated.types.Field;

public class DmcTypeFieldSET
extends DmcTypeField
implements Serializable {
    private static final Iterator<Field> emptyList = new HashSet().iterator();
    protected Set<Field> value;

    public DmcTypeFieldSET() {
        this.value = null;
    }

    public DmcTypeFieldSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Field>() : new TreeSet<Field>();
    }

    public DmcTypeFieldSET getNew() {
        return new DmcTypeFieldSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Field> cloneIt() {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            DmcTypeFieldSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Field val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field add(Object v) throws DmcValueException {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            Field rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field del(Object v) {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            Field rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Field> getMV() {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Field>(this.value).iterator();
            }
            return new TreeSet<Field>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Field> getMVCopy() {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Field>();
                }
                return new HashSet<Field>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Field>(this.value);
            }
            return new TreeSet<Field>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeFieldSET dmcTypeFieldSET = this;
        synchronized (dmcTypeFieldSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Field val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

