/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.FilterTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeFilterTypeEnum;

public class DmcTypeFilterTypeEnumSET
extends DmcTypeFilterTypeEnum
implements Serializable {
    private static final Iterator<FilterTypeEnum> emptyList = new HashSet().iterator();
    protected Set<FilterTypeEnum> value;

    public DmcTypeFilterTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeFilterTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<FilterTypeEnum>() : new TreeSet<FilterTypeEnum>();
    }

    public DmcTypeFilterTypeEnumSET getNew() {
        return new DmcTypeFilterTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<FilterTypeEnum> cloneIt() {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            DmcTypeFilterTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (FilterTypeEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterTypeEnum add(Object v) throws DmcValueException {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            FilterTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterTypeEnum del(Object v) {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            FilterTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FilterTypeEnum> getMV() {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<FilterTypeEnum>(this.value).iterator();
            }
            return new TreeSet<FilterTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FilterTypeEnum> getMVCopy() {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<FilterTypeEnum>();
                }
                return new HashSet<FilterTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<FilterTypeEnum>(this.value);
            }
            return new TreeSet<FilterTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeFilterTypeEnumSET dmcTypeFilterTypeEnumSET = this;
        synchronized (dmcTypeFilterTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                FilterTypeEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

