/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeFloat;

public class DmcTypeFloatMV
extends DmcTypeFloat
implements Serializable {
    private static final Iterator<Float> emptyList = new ArrayList().iterator();
    protected ArrayList<Float> value;

    public DmcTypeFloatMV() {
    }

    public DmcTypeFloatMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypeFloatMV getNew() {
        return new DmcTypeFloatMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Float> cloneIt() {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            DmcTypeFloatMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (Float val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float add(Object v) throws DmcValueException {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            Float rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float del(Object v) {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.value == null) {
                return null;
            }
            Float key = null;
            Float rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Float> getMV() {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<Float> clone = new ArrayList<Float>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Float> getMVCopy() {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.value == null) {
                return new ArrayList<Float>();
            }
            return new ArrayList<Float>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getMVnth(int index) {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float setMVnth(int index, Object v) throws DmcValueException {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            Float rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeFloatMV dmcTypeFloatMV = this;
        synchronized (dmcTypeFloatMV) {
            if (this.value == null) {
                return false;
            }
            try {
                Float val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

