/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeFloat;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeFloatSET
extends DmcTypeFloat
implements Serializable {
    private static final Iterator<Float> emptyList = new HashSet().iterator();
    protected Set<Float> value;

    public DmcTypeFloatSET() {
        this.value = null;
    }

    public DmcTypeFloatSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Float>() : new TreeSet<Float>();
    }

    public DmcTypeFloatSET getNew() {
        return new DmcTypeFloatSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Float> cloneIt() {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            DmcTypeFloatSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Float val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float add(Object v) throws DmcValueException {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            Float rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float del(Object v) {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            Float rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Float> getMV() {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Float>(this.value).iterator();
            }
            return new TreeSet<Float>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Float> getMVCopy() {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Float>();
                }
                return new HashSet<Float>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Float>(this.value);
            }
            return new TreeSet<Float>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeFloatSET dmcTypeFloatSET = this;
        synchronized (dmcTypeFloatSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Float val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

