/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeFullyQualifiedName;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeFullyQualifiedNameSET
extends DmcTypeFullyQualifiedName
implements Serializable {
    private static final Iterator<FullyQualifiedName> emptyList = new HashSet().iterator();
    protected Set<FullyQualifiedName> value;

    public DmcTypeFullyQualifiedNameSET() {
        this.value = null;
    }

    public DmcTypeFullyQualifiedNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<FullyQualifiedName>() : new TreeSet<FullyQualifiedName>();
    }

    public DmcTypeFullyQualifiedNameSET getNew() {
        return new DmcTypeFullyQualifiedNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<FullyQualifiedName> cloneIt() {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            DmcTypeFullyQualifiedNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (FullyQualifiedName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FullyQualifiedName add(Object v) throws DmcValueException {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            FullyQualifiedName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FullyQualifiedName del(Object v) {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            FullyQualifiedName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FullyQualifiedName> getMV() {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<FullyQualifiedName>(this.value).iterator();
            }
            return new TreeSet<FullyQualifiedName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FullyQualifiedName> getMVCopy() {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<FullyQualifiedName>();
                }
                return new HashSet<FullyQualifiedName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<FullyQualifiedName>(this.value);
            }
            return new TreeSet<FullyQualifiedName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeFullyQualifiedNameSET dmcTypeFullyQualifiedNameSET = this;
        synchronized (dmcTypeFullyQualifiedNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                FullyQualifiedName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

