/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerName;
import org.dmd.dmc.types.IntegerName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerNameSET
extends DmcTypeIntegerName
implements Serializable {
    private static final Iterator<IntegerName> emptyList = new HashSet().iterator();
    protected Set<IntegerName> value;

    public DmcTypeIntegerNameSET() {
        this.value = null;
    }

    public DmcTypeIntegerNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<IntegerName>() : new TreeSet<IntegerName>();
    }

    public DmcTypeIntegerNameSET getNew() {
        return new DmcTypeIntegerNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerName> cloneIt() {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            DmcTypeIntegerNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerName add(Object v) throws DmcValueException {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            IntegerName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerName del(Object v) {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            IntegerName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerName> getMV() {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<IntegerName>(this.value).iterator();
            }
            return new TreeSet<IntegerName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IntegerName> getMVCopy() {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<IntegerName>();
                }
                return new HashSet<IntegerName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<IntegerName>(this.value);
            }
            return new TreeSet<IntegerName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerNameSET dmcTypeIntegerNameSET = this;
        synchronized (dmcTypeIntegerNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

