/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeInteger;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerSET
extends DmcTypeInteger
implements Serializable {
    private static final Iterator<Integer> emptyList = new HashSet().iterator();
    protected Set<Integer> value;

    public DmcTypeIntegerSET() {
        this.value = null;
    }

    public DmcTypeIntegerSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Integer>() : new TreeSet<Integer>();
    }

    public DmcTypeIntegerSET getNew() {
        return new DmcTypeIntegerSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Integer> cloneIt() {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            DmcTypeIntegerSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Integer val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer add(Object v) throws DmcValueException {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            Integer rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer del(Object v) {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            Integer rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Integer> getMV() {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Integer>(this.value).iterator();
            }
            return new TreeSet<Integer>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getMVCopy() {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Integer>();
                }
                return new HashSet<Integer>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Integer>(this.value);
            }
            return new TreeSet<Integer>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerSET dmcTypeIntegerSET = this;
        synchronized (dmcTypeIntegerSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Integer val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

