/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerToBoolean;
import org.dmd.dmc.types.IntegerToBoolean;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerToBooleanMAP
extends DmcTypeIntegerToBoolean
implements Serializable {
    private static final Iterator<IntegerToBoolean> emptyList = new HashMap().values().iterator();
    protected Map<Integer, IntegerToBoolean> value;

    public DmcTypeIntegerToBooleanMAP() {
        this.value = null;
    }

    public DmcTypeIntegerToBooleanMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToBoolean>() : new TreeMap<Integer, IntegerToBoolean>();
    }

    public Integer firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (Integer)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeIntegerToBooleanMAP getNew() {
        return new DmcTypeIntegerToBooleanMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerToBoolean> cloneIt() {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            DmcTypeIntegerToBooleanMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerToBoolean val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToBoolean add(Object v) throws DmcValueException {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            Integer key;
            IntegerToBoolean oldval;
            IntegerToBoolean newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (Integer)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public IntegerToBoolean del(Object key) {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerToBoolean> getMV() {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToBoolean>(this.value) : new TreeMap<Integer, IntegerToBoolean>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, IntegerToBoolean> getMVCopy() {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<Integer, IntegerToBoolean>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<Integer, IntegerToBoolean>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public IntegerToBoolean getByKey(Object key) {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.get((Integer)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerToBoolean val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeIntegerToBooleanMAP dmcTypeIntegerToBooleanMAP = this;
        synchronized (dmcTypeIntegerToBooleanMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof Integer) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

