/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerToString;
import org.dmd.dmc.types.IntegerToString;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerToStringMAP
extends DmcTypeIntegerToString
implements Serializable {
    private static final Iterator<IntegerToString> emptyList = new HashMap().values().iterator();
    protected Map<Integer, IntegerToString> value;

    public DmcTypeIntegerToStringMAP() {
        this.value = null;
    }

    public DmcTypeIntegerToStringMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToString>() : new TreeMap<Integer, IntegerToString>();
    }

    public Integer firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (Integer)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeIntegerToStringMAP getNew() {
        return new DmcTypeIntegerToStringMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerToString> cloneIt() {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            DmcTypeIntegerToStringMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerToString val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToString add(Object v) throws DmcValueException {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            Integer key;
            IntegerToString oldval;
            IntegerToString newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (Integer)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public IntegerToString del(Object key) {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerToString> getMV() {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToString>(this.value) : new TreeMap<Integer, IntegerToString>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, IntegerToString> getMVCopy() {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<Integer, IntegerToString>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<Integer, IntegerToString>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public IntegerToString getByKey(Object key) {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.get((Integer)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerToString val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeIntegerToStringMAP dmcTypeIntegerToStringMAP = this;
        synchronized (dmcTypeIntegerToStringMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof Integer) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

