/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerToString;
import org.dmd.dmc.types.IntegerToString;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerToStringSET
extends DmcTypeIntegerToString
implements Serializable {
    private static final Iterator<IntegerToString> emptyList = new HashSet().iterator();
    protected Set<IntegerToString> value;

    public DmcTypeIntegerToStringSET() {
        this.value = null;
    }

    public DmcTypeIntegerToStringSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<IntegerToString>() : new TreeSet<IntegerToString>();
    }

    public DmcTypeIntegerToStringSET getNew() {
        return new DmcTypeIntegerToStringSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerToString> cloneIt() {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            DmcTypeIntegerToStringSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerToString val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToString add(Object v) throws DmcValueException {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            IntegerToString rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToString del(Object v) {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            IntegerToString rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerToString> getMV() {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<IntegerToString>(this.value).iterator();
            }
            return new TreeSet<IntegerToString>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IntegerToString> getMVCopy() {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<IntegerToString>();
                }
                return new HashSet<IntegerToString>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<IntegerToString>(this.value);
            }
            return new TreeSet<IntegerToString>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerToStringSET dmcTypeIntegerToStringSET = this;
        synchronized (dmcTypeIntegerToStringSET) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerToString val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

