/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerToUUIDLite;
import org.dmd.dmc.types.IntegerToUUIDLite;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerToUUIDLiteMAP
extends DmcTypeIntegerToUUIDLite
implements Serializable {
    private static final Iterator<IntegerToUUIDLite> emptyList = new HashMap().values().iterator();
    protected Map<Integer, IntegerToUUIDLite> value;

    public DmcTypeIntegerToUUIDLiteMAP() {
        this.value = null;
    }

    public DmcTypeIntegerToUUIDLiteMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToUUIDLite>() : new TreeMap<Integer, IntegerToUUIDLite>();
    }

    public Integer firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (Integer)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeIntegerToUUIDLiteMAP getNew() {
        return new DmcTypeIntegerToUUIDLiteMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerToUUIDLite> cloneIt() {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            DmcTypeIntegerToUUIDLiteMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerToUUIDLite val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToUUIDLite add(Object v) throws DmcValueException {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            Integer key;
            IntegerToUUIDLite oldval;
            IntegerToUUIDLite newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (Integer)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public IntegerToUUIDLite del(Object key) {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerToUUIDLite> getMV() {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<Integer, IntegerToUUIDLite>(this.value) : new TreeMap<Integer, IntegerToUUIDLite>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, IntegerToUUIDLite> getMVCopy() {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<Integer, IntegerToUUIDLite>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<Integer, IntegerToUUIDLite>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public IntegerToUUIDLite getByKey(Object key) {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof Integer) {
                return this.value.get((Integer)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerToUUIDLite val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeIntegerToUUIDLiteMAP dmcTypeIntegerToUUIDLiteMAP = this;
        synchronized (dmcTypeIntegerToUUIDLiteMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof Integer) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

