/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeIntegerToUUIDLite;
import org.dmd.dmc.types.IntegerToUUIDLite;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeIntegerToUUIDLiteSET
extends DmcTypeIntegerToUUIDLite
implements Serializable {
    private static final Iterator<IntegerToUUIDLite> emptyList = new HashSet().iterator();
    protected Set<IntegerToUUIDLite> value;

    public DmcTypeIntegerToUUIDLiteSET() {
        this.value = null;
    }

    public DmcTypeIntegerToUUIDLiteSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<IntegerToUUIDLite>() : new TreeSet<IntegerToUUIDLite>();
    }

    public DmcTypeIntegerToUUIDLiteSET getNew() {
        return new DmcTypeIntegerToUUIDLiteSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<IntegerToUUIDLite> cloneIt() {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            DmcTypeIntegerToUUIDLiteSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (IntegerToUUIDLite val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToUUIDLite add(Object v) throws DmcValueException {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            IntegerToUUIDLite rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerToUUIDLite del(Object v) {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            IntegerToUUIDLite rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IntegerToUUIDLite> getMV() {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<IntegerToUUIDLite>(this.value).iterator();
            }
            return new TreeSet<IntegerToUUIDLite>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IntegerToUUIDLite> getMVCopy() {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<IntegerToUUIDLite>();
                }
                return new HashSet<IntegerToUUIDLite>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<IntegerToUUIDLite>(this.value);
            }
            return new TreeSet<IntegerToUUIDLite>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeIntegerToUUIDLiteSET dmcTypeIntegerToUUIDLiteSET = this;
        synchronized (dmcTypeIntegerToUUIDLiteSET) {
            if (this.value == null) {
                return false;
            }
            try {
                IntegerToUUIDLite val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

