/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeLabelledIntegerDataPoint;
import org.dmd.dmc.types.LabelledIntegerDataPoint;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeLabelledIntegerDataPointSET
extends DmcTypeLabelledIntegerDataPoint
implements Serializable {
    private static final Iterator<LabelledIntegerDataPoint> emptyList = new HashSet().iterator();
    protected Set<LabelledIntegerDataPoint> value;

    public DmcTypeLabelledIntegerDataPointSET() {
        this.value = null;
    }

    public DmcTypeLabelledIntegerDataPointSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<LabelledIntegerDataPoint>() : new TreeSet<LabelledIntegerDataPoint>();
    }

    public DmcTypeLabelledIntegerDataPointSET getNew() {
        return new DmcTypeLabelledIntegerDataPointSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<LabelledIntegerDataPoint> cloneIt() {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            DmcTypeLabelledIntegerDataPointSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (LabelledIntegerDataPoint val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LabelledIntegerDataPoint add(Object v) throws DmcValueException {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            LabelledIntegerDataPoint rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LabelledIntegerDataPoint del(Object v) {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            LabelledIntegerDataPoint rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<LabelledIntegerDataPoint> getMV() {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<LabelledIntegerDataPoint>(this.value).iterator();
            }
            return new TreeSet<LabelledIntegerDataPoint>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LabelledIntegerDataPoint> getMVCopy() {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<LabelledIntegerDataPoint>();
                }
                return new HashSet<LabelledIntegerDataPoint>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<LabelledIntegerDataPoint>(this.value);
            }
            return new TreeSet<LabelledIntegerDataPoint>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeLabelledIntegerDataPointSET dmcTypeLabelledIntegerDataPointSET = this;
        synchronized (dmcTypeLabelledIntegerDataPointSET) {
            if (this.value == null) {
                return false;
            }
            try {
                LabelledIntegerDataPoint val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

