/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeLongName;
import org.dmd.dmc.types.LongName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeLongNameSET
extends DmcTypeLongName
implements Serializable {
    private static final Iterator<LongName> emptyList = new HashSet().iterator();
    protected Set<LongName> value;

    public DmcTypeLongNameSET() {
        this.value = null;
    }

    public DmcTypeLongNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<LongName>() : new TreeSet<LongName>();
    }

    public DmcTypeLongNameSET getNew() {
        return new DmcTypeLongNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<LongName> cloneIt() {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            DmcTypeLongNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (LongName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongName add(Object v) throws DmcValueException {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            LongName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongName del(Object v) {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            LongName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<LongName> getMV() {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<LongName>(this.value).iterator();
            }
            return new TreeSet<LongName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LongName> getMVCopy() {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<LongName>();
                }
                return new HashSet<LongName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<LongName>(this.value);
            }
            return new TreeSet<LongName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeLongNameSET dmcTypeLongNameSET = this;
        synchronized (dmcTypeLongNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                LongName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

