/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeLong;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeLongSET
extends DmcTypeLong
implements Serializable {
    private static final Iterator<Long> emptyList = new HashSet().iterator();
    protected Set<Long> value;

    public DmcTypeLongSET() {
        this.value = null;
    }

    public DmcTypeLongSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Long>() : new TreeSet<Long>();
    }

    public DmcTypeLongSET getNew() {
        return new DmcTypeLongSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Long> cloneIt() {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            DmcTypeLongSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Long val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long add(Object v) throws DmcValueException {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            Long rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(Object v) {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            Long rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Long> getMV() {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Long>(this.value).iterator();
            }
            return new TreeSet<Long>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getMVCopy() {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Long>();
                }
                return new HashSet<Long>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Long>(this.value);
            }
            return new TreeSet<Long>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeLongSET dmcTypeLongSET = this;
        synchronized (dmcTypeLongSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Long val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

