/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeModifier;
import org.dmd.dmc.types.Modifier;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeModifierSET
extends DmcTypeModifier
implements Serializable {
    private static final Iterator<Modifier> emptyList = new HashSet().iterator();
    protected Set<Modifier> value;

    public DmcTypeModifierSET() {
        this.value = null;
    }

    public DmcTypeModifierSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Modifier>() : new TreeSet<Modifier>();
    }

    public DmcTypeModifierSET getNew() {
        return new DmcTypeModifierSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Modifier> cloneIt() {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            DmcTypeModifierSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Modifier val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Modifier add(Object v) throws DmcValueException {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            Modifier rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Modifier del(Object v) {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            Modifier rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Modifier> getMV() {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Modifier>(this.value).iterator();
            }
            return new TreeSet<Modifier>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Modifier> getMVCopy() {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Modifier>();
                }
                return new HashSet<Modifier>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Modifier>(this.value);
            }
            return new TreeSet<Modifier>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeModifierSET dmcTypeModifierSET = this;
        synchronized (dmcTypeModifierSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Modifier val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

