/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeNameContainer;
import org.dmd.dmc.types.NameContainer;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeNameContainerSET
extends DmcTypeNameContainer
implements Serializable {
    private static final Iterator<NameContainer> emptyList = new HashSet().iterator();
    protected Set<NameContainer> value;

    public DmcTypeNameContainerSET() {
        this.value = null;
    }

    public DmcTypeNameContainerSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NameContainer>() : new TreeSet<NameContainer>();
    }

    public DmcTypeNameContainerSET getNew() {
        return new DmcTypeNameContainerSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NameContainer> cloneIt() {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            DmcTypeNameContainerSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NameContainer val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameContainer add(Object v) throws DmcValueException {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            NameContainer rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameContainer del(Object v) {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            NameContainer rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NameContainer> getMV() {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NameContainer>(this.value).iterator();
            }
            return new TreeSet<NameContainer>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameContainer> getMVCopy() {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NameContainer>();
                }
                return new HashSet<NameContainer>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NameContainer>(this.value);
            }
            return new TreeSet<NameContainer>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNameContainerSET dmcTypeNameContainerSET = this;
        synchronized (dmcTypeNameContainerSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NameContainer val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

