/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeNameValuePair;
import org.dmd.dms.generated.types.NameValuePair;

public class DmcTypeNameValuePairSET
extends DmcTypeNameValuePair
implements Serializable {
    private static final Iterator<NameValuePair> emptyList = new HashSet().iterator();
    protected Set<NameValuePair> value;

    public DmcTypeNameValuePairSET() {
        this.value = null;
    }

    public DmcTypeNameValuePairSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NameValuePair>() : new TreeSet<NameValuePair>();
    }

    public DmcTypeNameValuePairSET getNew() {
        return new DmcTypeNameValuePairSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NameValuePair> cloneIt() {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            DmcTypeNameValuePairSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NameValuePair val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameValuePair add(Object v) throws DmcValueException {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            NameValuePair rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameValuePair del(Object v) {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            NameValuePair rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NameValuePair> getMV() {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NameValuePair>(this.value).iterator();
            }
            return new TreeSet<NameValuePair>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameValuePair> getMVCopy() {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NameValuePair>();
                }
                return new HashSet<NameValuePair>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NameValuePair>(this.value);
            }
            return new TreeSet<NameValuePair>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNameValuePairSET dmcTypeNameValuePairSET = this;
        synchronized (dmcTypeNameValuePairSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NameValuePair val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

