/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeOptimize;
import org.dmd.dms.generated.types.Optimize;

public class DmcTypeOptimizeSET
extends DmcTypeOptimize
implements Serializable {
    private static final Iterator<Optimize> emptyList = new HashSet().iterator();
    protected Set<Optimize> value;

    public DmcTypeOptimizeSET() {
        this.value = null;
    }

    public DmcTypeOptimizeSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Optimize>() : new TreeSet<Optimize>();
    }

    public DmcTypeOptimizeSET getNew() {
        return new DmcTypeOptimizeSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Optimize> cloneIt() {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            DmcTypeOptimizeSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Optimize val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optimize add(Object v) throws DmcValueException {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            Optimize rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optimize del(Object v) {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            Optimize rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Optimize> getMV() {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Optimize>(this.value).iterator();
            }
            return new TreeSet<Optimize>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Optimize> getMVCopy() {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Optimize>();
                }
                return new HashSet<Optimize>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Optimize>(this.value);
            }
            return new TreeSet<Optimize>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeOptimizeSET dmcTypeOptimizeSET = this;
        synchronized (dmcTypeOptimizeSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Optimize val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

