/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.types.DmcTypePart;
import org.dmd.dms.generated.types.Part;

public class DmcTypePartMV
extends DmcTypePart
implements Serializable {
    private static final Iterator<Part> emptyList = new ArrayList().iterator();
    protected ArrayList<Part> value;

    public DmcTypePartMV() {
    }

    public DmcTypePartMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypePartMV getNew() {
        return new DmcTypePartMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Part> cloneIt() {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            DmcTypePartMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (Part val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part add(Object v) throws DmcValueException {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            Part rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part del(Object v) {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.value == null) {
                return null;
            }
            Part key = null;
            Part rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Part> getMV() {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<Part> clone = new ArrayList<Part>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Part> getMVCopy() {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.value == null) {
                return new ArrayList<Part>();
            }
            return new ArrayList<Part>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part getMVnth(int index) {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part setMVnth(int index, Object v) throws DmcValueException {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            Part rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePartMV dmcTypePartMV = this;
        synchronized (dmcTypePartMV) {
            if (this.value == null) {
                return false;
            }
            try {
                Part val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

