/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypePart;
import org.dmd.dms.generated.types.Part;

public class DmcTypePartSET
extends DmcTypePart
implements Serializable {
    private static final Iterator<Part> emptyList = new HashSet().iterator();
    protected Set<Part> value;

    public DmcTypePartSET() {
        this.value = null;
    }

    public DmcTypePartSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Part>() : new TreeSet<Part>();
    }

    public DmcTypePartSET getNew() {
        return new DmcTypePartSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Part> cloneIt() {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            DmcTypePartSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Part val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part add(Object v) throws DmcValueException {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            Part rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Part del(Object v) {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            Part rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Part> getMV() {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Part>(this.value).iterator();
            }
            return new TreeSet<Part>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Part> getMVCopy() {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Part>();
                }
                return new HashSet<Part>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Part>(this.value);
            }
            return new TreeSet<Part>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePartSET dmcTypePartSET = this;
        synchronized (dmcTypePartSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Part val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

