/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeRuleDataREF;
import org.dmd.dms.generated.types.RuleDataREF;

public class DmcTypeRuleDataREFSET
extends DmcTypeRuleDataREF
implements Serializable {
    private static final Iterator<RuleDataREF> emptyList = new HashSet().iterator();
    protected Set<RuleDataREF> value;

    public DmcTypeRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypeRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<RuleDataREF>() : new TreeSet<RuleDataREF>();
    }

    public DmcTypeRuleDataREFSET getNew() {
        return new DmcTypeRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<RuleDataREF> cloneIt() {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            DmcTypeRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (RuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleDataREF add(Object v) throws DmcValueException {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            RuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleDataREF del(Object v) {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            RuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RuleDataREF> getMV() {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<RuleDataREF>(this.value).iterator();
            }
            return new TreeSet<RuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RuleDataREF> getMVCopy() {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<RuleDataREF>();
                }
                return new HashSet<RuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<RuleDataREF>(this.value);
            }
            return new TreeSet<RuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeRuleDataREFSET dmcTypeRuleDataREFSET = this;
        synchronized (dmcTypeRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                RuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

