/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeRuleDefinitionREF;
import org.dmd.dms.generated.types.RuleDefinitionREF;

public class DmcTypeRuleDefinitionREFSET
extends DmcTypeRuleDefinitionREF
implements Serializable {
    private static final Iterator<RuleDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<RuleDefinitionREF> value;

    public DmcTypeRuleDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeRuleDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<RuleDefinitionREF>() : new TreeSet<RuleDefinitionREF>();
    }

    public DmcTypeRuleDefinitionREFSET getNew() {
        return new DmcTypeRuleDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<RuleDefinitionREF> cloneIt() {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            DmcTypeRuleDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (RuleDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            RuleDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleDefinitionREF del(Object v) {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            RuleDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RuleDefinitionREF> getMV() {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<RuleDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<RuleDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RuleDefinitionREF> getMVCopy() {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<RuleDefinitionREF>();
                }
                return new HashSet<RuleDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<RuleDefinitionREF>(this.value);
            }
            return new TreeSet<RuleDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeRuleDefinitionREFSET dmcTypeRuleDefinitionREFSET = this;
        synchronized (dmcTypeRuleDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                RuleDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

