/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeRuleName;
import org.dmd.dmc.types.RuleName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeRuleNameSET
extends DmcTypeRuleName
implements Serializable {
    private static final Iterator<RuleName> emptyList = new HashSet().iterator();
    protected Set<RuleName> value;

    public DmcTypeRuleNameSET() {
        this.value = null;
    }

    public DmcTypeRuleNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<RuleName>() : new TreeSet<RuleName>();
    }

    public DmcTypeRuleNameSET getNew() {
        return new DmcTypeRuleNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<RuleName> cloneIt() {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            DmcTypeRuleNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (RuleName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleName add(Object v) throws DmcValueException {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            RuleName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleName del(Object v) {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            RuleName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RuleName> getMV() {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<RuleName>(this.value).iterator();
            }
            return new TreeSet<RuleName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RuleName> getMVCopy() {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<RuleName>();
                }
                return new HashSet<RuleName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<RuleName>(this.value);
            }
            return new TreeSet<RuleName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeRuleNameSET dmcTypeRuleNameSET = this;
        synchronized (dmcTypeRuleNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                RuleName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

