/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeRuleParam;
import org.dmd.dms.generated.types.RuleParam;

public class DmcTypeRuleParamSET
extends DmcTypeRuleParam
implements Serializable {
    private static final Iterator<RuleParam> emptyList = new HashSet().iterator();
    protected Set<RuleParam> value;

    public DmcTypeRuleParamSET() {
        this.value = null;
    }

    public DmcTypeRuleParamSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<RuleParam>() : new TreeSet<RuleParam>();
    }

    public DmcTypeRuleParamSET getNew() {
        return new DmcTypeRuleParamSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<RuleParam> cloneIt() {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            DmcTypeRuleParamSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (RuleParam val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleParam add(Object v) throws DmcValueException {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            RuleParam rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleParam del(Object v) {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            RuleParam rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RuleParam> getMV() {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<RuleParam>(this.value).iterator();
            }
            return new TreeSet<RuleParam>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RuleParam> getMVCopy() {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<RuleParam>();
                }
                return new HashSet<RuleParam>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<RuleParam>(this.value);
            }
            return new TreeSet<RuleParam>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeRuleParamSET dmcTypeRuleParamSET = this;
        synchronized (dmcTypeRuleParamSET) {
            if (this.value == null) {
                return false;
            }
            try {
                RuleParam val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

