/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeRunContextREF;
import org.dmd.dms.generated.types.RunContextREF;

public class DmcTypeRunContextREFSET
extends DmcTypeRunContextREF
implements Serializable {
    private static final Iterator<RunContextREF> emptyList = new HashSet().iterator();
    protected Set<RunContextREF> value;

    public DmcTypeRunContextREFSET() {
        this.value = null;
    }

    public DmcTypeRunContextREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<RunContextREF>() : new TreeSet<RunContextREF>();
    }

    public DmcTypeRunContextREFSET getNew() {
        return new DmcTypeRunContextREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<RunContextREF> cloneIt() {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            DmcTypeRunContextREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (RunContextREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunContextREF add(Object v) throws DmcValueException {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            RunContextREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunContextREF del(Object v) {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            RunContextREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RunContextREF> getMV() {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<RunContextREF>(this.value).iterator();
            }
            return new TreeSet<RunContextREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RunContextREF> getMVCopy() {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<RunContextREF>();
                }
                return new HashSet<RunContextREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<RunContextREF>(this.value);
            }
            return new TreeSet<RunContextREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeRunContextREFSET dmcTypeRunContextREFSET = this;
        synchronized (dmcTypeRunContextREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                RunContextREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

