/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeSchemaAndReason;
import org.dmd.dms.generated.types.SchemaAndReason;

public class DmcTypeSchemaAndReasonSET
extends DmcTypeSchemaAndReason
implements Serializable {
    private static final Iterator<SchemaAndReason> emptyList = new HashSet().iterator();
    protected Set<SchemaAndReason> value;

    public DmcTypeSchemaAndReasonSET() {
        this.value = null;
    }

    public DmcTypeSchemaAndReasonSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SchemaAndReason>() : new TreeSet<SchemaAndReason>();
    }

    public DmcTypeSchemaAndReasonSET getNew() {
        return new DmcTypeSchemaAndReasonSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SchemaAndReason> cloneIt() {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            DmcTypeSchemaAndReasonSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SchemaAndReason val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaAndReason add(Object v) throws DmcValueException {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            SchemaAndReason rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaAndReason del(Object v) {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            SchemaAndReason rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SchemaAndReason> getMV() {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SchemaAndReason>(this.value).iterator();
            }
            return new TreeSet<SchemaAndReason>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SchemaAndReason> getMVCopy() {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SchemaAndReason>();
                }
                return new HashSet<SchemaAndReason>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SchemaAndReason>(this.value);
            }
            return new TreeSet<SchemaAndReason>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSchemaAndReasonSET dmcTypeSchemaAndReasonSET = this;
        synchronized (dmcTypeSchemaAndReasonSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SchemaAndReason val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

