/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeShort;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeShortSET
extends DmcTypeShort
implements Serializable {
    private static final Iterator<Short> emptyList = new HashSet().iterator();
    protected Set<Short> value;

    public DmcTypeShortSET() {
        this.value = null;
    }

    public DmcTypeShortSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Short>() : new TreeSet<Short>();
    }

    public DmcTypeShortSET getNew() {
        return new DmcTypeShortSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Short> cloneIt() {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            DmcTypeShortSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Short val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short add(Object v) throws DmcValueException {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            Short rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short del(Object v) {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            Short rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Short> getMV() {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Short>(this.value).iterator();
            }
            return new TreeSet<Short>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Short> getMVCopy() {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Short>();
                }
                return new HashSet<Short>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Short>(this.value);
            }
            return new TreeSet<Short>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeShortSET dmcTypeShortSET = this;
        synchronized (dmcTypeShortSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Short val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

