/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeSliceDefinitionREF;
import org.dmd.dms.generated.types.SliceDefinitionREF;

public class DmcTypeSliceDefinitionREFSET
extends DmcTypeSliceDefinitionREF
implements Serializable {
    private static final Iterator<SliceDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<SliceDefinitionREF> value;

    public DmcTypeSliceDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeSliceDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SliceDefinitionREF>() : new TreeSet<SliceDefinitionREF>();
    }

    public DmcTypeSliceDefinitionREFSET getNew() {
        return new DmcTypeSliceDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SliceDefinitionREF> cloneIt() {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            DmcTypeSliceDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SliceDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SliceDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            SliceDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SliceDefinitionREF del(Object v) {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            SliceDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SliceDefinitionREF> getMV() {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SliceDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<SliceDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SliceDefinitionREF> getMVCopy() {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SliceDefinitionREF>();
                }
                return new HashSet<SliceDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SliceDefinitionREF>(this.value);
            }
            return new TreeSet<SliceDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSliceDefinitionREFSET dmcTypeSliceDefinitionREFSET = this;
        synchronized (dmcTypeSliceDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SliceDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

