/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeString;

public class DmcTypeStringMV
extends DmcTypeString
implements Serializable {
    private static final Iterator<String> emptyList = new ArrayList().iterator();
    protected ArrayList<String> value;

    public DmcTypeStringMV() {
    }

    public DmcTypeStringMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypeStringMV getNew() {
        return new DmcTypeStringMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<String> cloneIt() {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            DmcTypeStringMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (String val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String add(Object v) throws DmcValueException {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            String rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String del(Object v) {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.value == null) {
                return null;
            }
            String key = null;
            String rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getMV() {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<String> clone = new ArrayList<String>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getMVCopy() {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.value == null) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMVnth(int index) {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setMVnth(int index, Object v) throws DmcValueException {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            String rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeStringMV dmcTypeStringMV = this;
        synchronized (dmcTypeStringMV) {
            if (this.value == null) {
                return false;
            }
            try {
                String val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

