/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeStringToString;
import org.dmd.dmc.types.StringToString;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeStringToStringMAP
extends DmcTypeStringToString
implements Serializable {
    private static final Iterator<StringToString> emptyList = new HashMap().values().iterator();
    protected Map<String, StringToString> value;

    public DmcTypeStringToStringMAP() {
        this.value = null;
    }

    public DmcTypeStringToStringMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<String, StringToString>() : new TreeMap<String, StringToString>();
    }

    public String firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (String)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeStringToStringMAP getNew() {
        return new DmcTypeStringToStringMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<StringToString> cloneIt() {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            DmcTypeStringToStringMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (StringToString val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringToString add(Object v) throws DmcValueException {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            String key;
            StringToString oldval;
            StringToString newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (String)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public StringToString del(Object key) {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof String) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<StringToString> getMV() {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<String, StringToString>(this.value) : new TreeMap<String, StringToString>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, StringToString> getMVCopy() {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<String, StringToString>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<String, StringToString>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public StringToString getByKey(Object key) {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof String) {
                return this.value.get((String)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                StringToString val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeStringToStringMAP dmcTypeStringToStringMAP = this;
        synchronized (dmcTypeStringToStringMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof String) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

