/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeStringToString;
import org.dmd.dmc.types.StringToString;

public class DmcTypeStringToStringMV
extends DmcTypeStringToString
implements Serializable {
    private static final Iterator<StringToString> emptyList = new ArrayList().iterator();
    protected ArrayList<StringToString> value;

    public DmcTypeStringToStringMV() {
    }

    public DmcTypeStringToStringMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypeStringToStringMV getNew() {
        return new DmcTypeStringToStringMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<StringToString> cloneIt() {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            DmcTypeStringToStringMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (StringToString val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringToString add(Object v) throws DmcValueException {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            StringToString rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringToString del(Object v) {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.value == null) {
                return null;
            }
            StringToString key = null;
            StringToString rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<StringToString> getMV() {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<StringToString> clone = new ArrayList<StringToString>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StringToString> getMVCopy() {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.value == null) {
                return new ArrayList<StringToString>();
            }
            return new ArrayList<StringToString>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringToString getMVnth(int index) {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringToString setMVnth(int index, Object v) throws DmcValueException {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            StringToString rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeStringToStringMV dmcTypeStringToStringMV = this;
        synchronized (dmcTypeStringToStringMV) {
            if (this.value == null) {
                return false;
            }
            try {
                StringToString val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

