/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeTypeDefinitionREF;
import org.dmd.dms.generated.types.TypeDefinitionREF;

public class DmcTypeTypeDefinitionREFSET
extends DmcTypeTypeDefinitionREF
implements Serializable {
    private static final Iterator<TypeDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<TypeDefinitionREF> value;

    public DmcTypeTypeDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeTypeDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<TypeDefinitionREF>() : new TreeSet<TypeDefinitionREF>();
    }

    public DmcTypeTypeDefinitionREFSET getNew() {
        return new DmcTypeTypeDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<TypeDefinitionREF> cloneIt() {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            DmcTypeTypeDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (TypeDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            TypeDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinitionREF del(Object v) {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            TypeDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TypeDefinitionREF> getMV() {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<TypeDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<TypeDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TypeDefinitionREF> getMVCopy() {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<TypeDefinitionREF>();
                }
                return new HashSet<TypeDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<TypeDefinitionREF>(this.value);
            }
            return new TreeSet<TypeDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeTypeDefinitionREFSET dmcTypeTypeDefinitionREFSET = this;
        synchronized (dmcTypeTypeDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                TypeDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

