/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeUUIDLite;
import org.dmd.dmc.types.UUIDLite;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeUUIDLiteSET
extends DmcTypeUUIDLite
implements Serializable {
    private static final Iterator<UUIDLite> emptyList = new HashSet().iterator();
    protected Set<UUIDLite> value;

    public DmcTypeUUIDLiteSET() {
        this.value = null;
    }

    public DmcTypeUUIDLiteSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UUIDLite>() : new TreeSet<UUIDLite>();
    }

    public DmcTypeUUIDLiteSET getNew() {
        return new DmcTypeUUIDLiteSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<UUIDLite> cloneIt() {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            DmcTypeUUIDLiteSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UUIDLite val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUIDLite add(Object v) throws DmcValueException {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            UUIDLite rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUIDLite del(Object v) {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            UUIDLite rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<UUIDLite> getMV() {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UUIDLite>(this.value).iterator();
            }
            return new TreeSet<UUIDLite>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUIDLite> getMVCopy() {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UUIDLite>();
                }
                return new HashSet<UUIDLite>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UUIDLite>(this.value);
            }
            return new TreeSet<UUIDLite>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeUUIDLiteSET dmcTypeUUIDLiteSET = this;
        synchronized (dmcTypeUUIDLiteSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UUIDLite val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

