/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeValueTypeEnum;

public class DmcTypeValueTypeEnumSET
extends DmcTypeValueTypeEnum
implements Serializable {
    private static final Iterator<ValueTypeEnum> emptyList = new HashSet().iterator();
    protected Set<ValueTypeEnum> value;

    public DmcTypeValueTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeValueTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ValueTypeEnum>() : new TreeSet<ValueTypeEnum>();
    }

    public DmcTypeValueTypeEnumSET getNew() {
        return new DmcTypeValueTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ValueTypeEnum> cloneIt() {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            DmcTypeValueTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ValueTypeEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueTypeEnum add(Object v) throws DmcValueException {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            ValueTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueTypeEnum del(Object v) {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            ValueTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ValueTypeEnum> getMV() {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ValueTypeEnum>(this.value).iterator();
            }
            return new TreeSet<ValueTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ValueTypeEnum> getMVCopy() {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ValueTypeEnum>();
                }
                return new HashSet<ValueTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ValueTypeEnum>(this.value);
            }
            return new TreeSet<ValueTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeValueTypeEnumSET dmcTypeValueTypeEnumSET = this;
        synchronized (dmcTypeValueTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ValueTypeEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

