/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.dms.generated.types.DmcTypeWrapperTypeEnum;

public class DmcTypeWrapperTypeEnumSET
extends DmcTypeWrapperTypeEnum
implements Serializable {
    private static final Iterator<WrapperTypeEnum> emptyList = new HashSet().iterator();
    protected Set<WrapperTypeEnum> value;

    public DmcTypeWrapperTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeWrapperTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<WrapperTypeEnum>() : new TreeSet<WrapperTypeEnum>();
    }

    public DmcTypeWrapperTypeEnumSET getNew() {
        return new DmcTypeWrapperTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<WrapperTypeEnum> cloneIt() {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            DmcTypeWrapperTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (WrapperTypeEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrapperTypeEnum add(Object v) throws DmcValueException {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            WrapperTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrapperTypeEnum del(Object v) {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            WrapperTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<WrapperTypeEnum> getMV() {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<WrapperTypeEnum>(this.value).iterator();
            }
            return new TreeSet<WrapperTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<WrapperTypeEnum> getMVCopy() {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<WrapperTypeEnum>();
                }
                return new HashSet<WrapperTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<WrapperTypeEnum>(this.value);
            }
            return new TreeSet<WrapperTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeWrapperTypeEnumSET dmcTypeWrapperTypeEnumSET = this;
        synchronized (dmcTypeWrapperTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                WrapperTypeEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

