/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.meta;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.ComplexTypeSplitter;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.dms.meta.MetaGenerator;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class MetaComplexTypeFormatter {
    static MetaGenerator meta;

    /*
     * WARNING - void declaration
     */
    static void dumpComplexType(String od, DmcUncheckedObject ct, MetaGenerator mg) throws IOException, ResultException, DmcValueException {
        meta = mg;
        String ctn = ct.getSV("name");
        String fieldSeparator = ct.getSV("fieldSeparator");
        boolean whiteSpaceSeparator = false;
        if (fieldSeparator == null) {
            whiteSpaceSeparator = true;
            fieldSeparator = " ";
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, ctn + ".java");
        DebugInfo.debug("Generating: " + od + File.separator + ctn + ".java");
        ArrayList<Part> parts = new ArrayList<Part>();
        MetaComplexTypeFormatter.getComplexTypeParts("requiredPart", ct, parts);
        int requiredCount = parts.size();
        MetaComplexTypeFormatter.getComplexTypeParts("optionalPart", ct, parts);
        boolean hasRefs = false;
        boolean isGreedy = false;
        ArrayList<String> refFields = new ArrayList<String>();
        for (Part part : parts) {
            void var14_23;
            String isRefType;
            DmcUncheckedObject dmcUncheckedObject;
            DmcUncheckedObject dmcUncheckedObject2 = MetaComplexTypeFormatter.meta.typeDefs.get(part.type);
            if (dmcUncheckedObject2 == null && (dmcUncheckedObject = MetaComplexTypeFormatter.meta.enumDefs.get(part.type)) == null) {
                DebugInfo.debug("Unknown type in ComplexTypeDefinition: " + part.type);
                System.exit(1);
            }
            if ((isRefType = var14_23.getSV("isRefType")) != null) {
                hasRefs = true;
                refFields.add(part.name);
            }
            if (!part.greedy) continue;
            isGreedy = true;
        }
        out.write(MetaComplexTypeFormatter.meta.LGPL.toString());
        out.write("package org.dmd.dms.generated.types;\n\n");
        ImportManager imports = new ImportManager();
        imports.addImport("java.io.Serializable", "Marker interface for serialization");
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dms.generated.enums.ValueTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dmc.DmcAttributeInfo", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dmc.util.ComplexTypeSplitter", "For parsing initial input");
        imports.addImport("java.util.ArrayList", "To store ParsedNameValuePairs");
        imports.addImport("org.dmd.dmc.util.ParsedNameValuePair", "To store values parsed from initial input");
        if (hasRefs) {
            imports.addImport("org.dmd.dmc.DmcNameResolverWithClashSupportIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameClashResolverIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameResolverIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcNamedObjectIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcNamedObjectREF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcContainerIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcObject", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcValueExceptionSet", "Ambiguous reference resolution");
        }
        imports.addImport("org.dmd.dmc.DmcValueException", "For type checking");
        MetaComplexTypeFormatter.getComplexTypeImports(imports, parts);
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The " + ctn + " class.\n");
        out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
        out.write(" * manually.\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + ctn + " implements Serializable {\n\n");
        out.write(MetaComplexTypeFormatter.getComplexTypeFieldInstances(parts));
        out.write("    final static int requiredParts = " + requiredCount + ";\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Copy constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(" + ctn + " original){\n");
        for (Part part : parts) {
            out.write("        " + part.name + " = original." + part.name + ";\n");
        }
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    /**\n");
        out.write("     * All fields constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(");
        boolean bl = true;
        for (Part field : parts) {
            void var13_16;
            out.write(field.type + " f" + (int)var13_16);
            if (++var13_16 > parts.size()) continue;
            out.write(", ");
        }
        out.write(") throws DmcValueException {\n");
        boolean bl2 = true;
        for (Part field : parts) {
            void var13_18;
            if (var13_18 > requiredCount) {
                out.write("        if (f" + (int)var13_18 + " != null)\n");
                out.write("            " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(f" + (int)var13_18 + ");\n");
            } else {
                out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(f" + (int)var13_18 + ");\n");
            }
            ++var13_18;
        }
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    /**\n");
        out.write("     * String based constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(String initialInput) throws DmcValueException {\n");
        out.write("        initialize(initialInput);\n");
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    void initialize(String initialInput) throws DmcValueException {\n");
        int n = parts.size() - 1;
        if (whiteSpaceSeparator) {
            if (isGreedy) {
                out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,' '," + n + ");\n\n");
            } else {
                out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput);\n\n");
            }
        } else if (isGreedy) {
            out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,'" + fieldSeparator + "', " + n + ");\n\n");
        } else {
            out.write("        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,'" + fieldSeparator + "');\n\n");
        }
        out.write("        if (nvp.size() < requiredParts)\n");
        out.write("            throw(new DmcValueException(\"Missing required values for complex type: " + ctn + "\"));\n");
        out.write("\n");
        boolean bl3 = false;
        boolean firstOptional = true;
        for (Part field : parts) {
            void var13_20;
            if (var13_20 < requiredCount) {
                out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(nvp.get(" + (int)var13_20 + ").getValue());\n");
            } else {
                if (firstOptional) {
                    out.write("\n");
                    out.write("        if (nvp.size() > requiredParts){\n");
                    out.write("            for(int i=" + requiredCount + "; i<nvp.size(); i++){\n");
                    out.write("                if (nvp.get(i).getName() == null){\n");
                    out.write("                    if (nvp.get(i).getValue() == null)\n");
                    out.write("                        throw(new DmcValueException(\"Expecting a partname=\\\"some value\\\" in complex type: " + ctn + "\"));\n");
                    out.write("                    else\n");
                    out.write("                        throw(new DmcValueException(\"Expecting a partname=\\\"\" + nvp.get(i).getValue() + \"\\\" in complex type: " + ctn + "\"));\n");
                    out.write("                }\n");
                    firstOptional = false;
                    out.write("                if (nvp.get(i).getName().equals(\"" + field.name + "\"))\n");
                } else {
                    out.write("                else if (nvp.get(i).getName().equals(\"" + field.name + "\"))\n");
                }
                out.write("                    " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(nvp.get(i).getValue());\n");
            }
            ++var13_20;
        }
        if (!firstOptional) {
            out.write("                else{\n");
            out.write("                    throw(new DmcValueException(\"Unknown field for complex type " + ctn + ": \"  + nvp.get(i).getName()));\n");
            out.write("                }\n");
            out.write("            }\n");
            out.write("        }\n\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Serialization.\n");
        out.write("     */\n");
        out.write("    public void serializeIt(DmcOutputStreamIF dos) throws Exception {\n");
        out.write("        dos.writeUTF(toString());\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Deserialization.\n");
        out.write("     */\n");
        out.write("    public void deserializeIt(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        initialize(dis.readUTF());\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String form.\n");
        out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("     */\n");
        out.write("    public String toString(){\n");
        out.write("        StringBuffer sb = new StringBuffer();\n");
        boolean bl4 = false;
        for (Part field : parts) {
            void var13_22;
            String appendStatement = null;
            appendStatement = field.quoted ? "        sb.append(\"\\\"\" + " + field.name + ".toString() + \"\\\"\");\n" : "        sb.append(" + field.name + ".toString());\n";
            if (var13_22 < requiredCount) {
                if (var13_22 == false) {
                    out.write(appendStatement);
                } else {
                    out.write("        sb.append('" + fieldSeparator + "');\n");
                    out.write(appendStatement);
                }
            } else {
                appendStatement = field.quoted ? "        sb.append(\"" + field.name + "=\" + \"\\\"\" + " + field.name + ".toString() + \"\\\"\");\n" : "        sb.append(\"" + field.name + "=\" + " + field.name + ".toString());\n";
                out.write("        if (" + field.name + " != null){\n");
                if (var13_22 == false) {
                    out.write("    " + appendStatement);
                } else {
                    out.write("            sb.append('" + fieldSeparator + "');\n");
                    out.write("    " + appendStatement);
                }
                out.write("        }\n\n");
            }
            ++var13_22;
        }
        out.write("        return(sb.toString());\n");
        out.write("    }\n\n");
        for (Part field : parts) {
            out.write("    public " + field.type + " get" + Manipulator.capFirstChar(field.name) + "(){\n");
            out.write("        return(" + field.name + ");\n");
            out.write("    }\n\n");
        }
        if (hasRefs) {
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (String fn : refFields) {
                out.write("        if ((" + fn + " != null) && (!" + fn + ".isResolved())){\n");
                out.write("            obj = resolver.findNamedObject(" + fn + ".getObjectName());\n");
                out.write("            if (obj == null)\n");
                out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + fn + ".getObjectName() + \" via attribute: \" + attrName));\n");
                out.write("        \n");
                out.write("            if (obj instanceof DmcContainerIF)\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                out.write("            else\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject(obj);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (String fn : refFields) {
                out.write("        if ((" + fn + " != null) && (!" + fn + ".isResolved())){\n");
                out.write("            obj = resolver.findNamedObjectMayClash(object, " + fn + ".getObjectName(), ncr, " + fn + "AI);\n");
                out.write("            if (obj == null)\n");
                out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + fn + ".getObjectName() + \" via attribute: \" + ai.name));\n");
                out.write("        \n");
                out.write("            if (obj instanceof DmcContainerIF)\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                out.write("            else\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject(obj);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void removeBackRefsFromValue(){\n");
            out.write("    }\n\n");
        }
        out.write("    public void toJSON(StringBuffer sb, int padding, String indent) {\n");
        out.write("        throw(new IllegalStateException(\"This needs to be implemented\"));\n");
        out.write("    }\n\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
        GenUtility.dumpComplexTypeDmcType(mg.LGPL.toString(), "org.dmd.dms", od, ctn, hasRefs);
    }

    static void getComplexTypeImports(ImportManager imports, ArrayList<Part> fields) throws ResultException {
        for (Part field : fields) {
            DmcUncheckedObject typeDef = MetaComplexTypeFormatter.meta.typeDefs.get(field.type);
            if (typeDef != null) continue;
            typeDef = MetaComplexTypeFormatter.meta.enumDefs.get(field.type);
            if (typeDef != null) {
                String imp = "org.dmd.dms.generated.enums." + field.type;
                imports.addImport(imp, "Type for field: " + field.name);
                continue;
            }
            typeDef = MetaComplexTypeFormatter.meta.typeDefs.get(field.type + "REF");
            String primitiveType = typeDef.getSV("primitiveType");
            if (primitiveType == null) continue;
            imports.addImport(primitiveType, "Type for field: " + field.name);
        }
    }

    static String getComplexTypeFieldInstances(ArrayList<Part> fields) {
        StringBuffer sb = new StringBuffer();
        for (Part field : fields) {
            sb.append("    // " + field.descr + "\n");
            sb.append("    " + field.type + " " + field.name + ";\n");
            String type = field.type;
            type = type.replaceAll("REF", "");
            sb.append("    final static DmcAttributeInfo " + field.name + "AI = new DmcAttributeInfo(\"" + field.name + "\",0,\"" + type + "\",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);\n\n");
        }
        return sb.toString();
    }

    static void getComplexTypeParts(String attrName, DmcUncheckedObject ct, ArrayList<Part> rc) throws DmcValueException {
        ArrayList<ParsedNameValuePair> partNVP = null;
        NamedStringArray parts = ct.get(attrName);
        if (parts == null) {
            return;
        }
        for (String part : parts) {
            DmcUncheckedObject typeDef;
            partNVP = ComplexTypeSplitter.parse(part);
            String type = partNVP.get(0).getValue();
            String name = partNVP.get(1).getValue();
            String descr = partNVP.get(2).getValue();
            String quoted = null;
            String multivalued = null;
            String weakref = null;
            String greedy = null;
            if (partNVP.size() > 3) {
                for (int i = 3; i < partNVP.size(); ++i) {
                    if (partNVP.get(i).getName().equals("quoted")) {
                        quoted = partNVP.get(i).getValue();
                        continue;
                    }
                    if (partNVP.get(i).getName().equals("multivalued")) {
                        multivalued = partNVP.get(i).getValue();
                        continue;
                    }
                    if (partNVP.get(i).getName().equals("weakref")) {
                        weakref = partNVP.get(i).getValue();
                        continue;
                    }
                    if (!partNVP.get(i).getName().equals("greedy")) continue;
                    greedy = partNVP.get(i).getValue();
                }
            }
            if ((typeDef = MetaComplexTypeFormatter.meta.typeDefs.get(type)) == null && MetaComplexTypeFormatter.meta.enumDefs.get(type) == null) {
                type = type + "REF";
            }
            rc.add(new Part(type, name, descr, quoted, multivalued, weakref, greedy));
        }
    }

    static class Part {
        String type;
        String name;
        String descr;
        boolean quoted;
        boolean multivalued;
        boolean weakref;
        boolean greedy;

        Part(String t, String n, String d, String q, String m, String w, String g) {
            this.type = t;
            this.name = n;
            this.descr = d;
            if (q != null && q.toLowerCase().equals("true")) {
                this.quoted = true;
            }
            if (m != null && m.toLowerCase().equals("true")) {
                this.multivalued = true;
            }
            if (w != null && w.toLowerCase().equals("true")) {
                this.weakref = true;
            }
            if (g != null && g.toLowerCase().equals("true")) {
                this.greedy = true;
            }
        }
    }
}

