/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.meta;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dms.meta.MetaComplexTypeFormatter;
import org.dmd.dms.types.EnumValue;
import org.dmd.dms.util.DmoCompactSchemaFormatter;
import org.dmd.dms.util.GenUtility;
import org.dmd.dms.util.RuleFormatter;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class MetaGenerator
implements DmcUncheckedOIFHandlerIF {
    private static final String METADIR = "/src/org/dmd/dms/meta";
    private static final String DMWDIR = "/src/org/dmd/dms/generated/dmw";
    private static final String ENUMDIR = "/src/org/dmd/dms/generated/enums";
    private static final String DMODIR = "/src/org/dmd/dms/generated/dmo";
    private static final String TYPEDIR = "/src/org/dmd/dms/generated/types";
    private static final String RULESDIR = "/src/org/dmd/dms/generated/rulesdmo";
    private static final String DMSDIR = "/src/org/dmd/dms";
    private static final int META_BASE_ID = 0;
    private static final int META_ID_RANGE = 200;
    StringBuffer LGPL;
    TreeMap<String, DmcUncheckedObject> allDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> typeDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> enumDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> attributeDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> classDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> complexTypeDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> avDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> ovDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> ruleDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> ruleCategoryDefs = new TreeMap();
    TreeMap<String, DmcUncheckedObject> dmModuleDefs = new TreeMap();
    ArrayList<DmcUncheckedObject> ruleInstances = new ArrayList();
    ArrayList<String> origOrderClasses = new ArrayList();
    ArrayList<String> origOrderAttrs = new ArrayList();
    ArrayList<String> origOrderTypes = new ArrayList();
    ArrayList<String> origOrderEnums = new ArrayList();
    ArrayList<String> origOrderComplexTypes = new ArrayList();
    ArrayList<String> origOrderAVDs = new ArrayList();
    ArrayList<String> origOrderOVDs = new ArrayList();
    ArrayList<String> origOrderRules = new ArrayList();
    ArrayList<String> origOrderCategories = new ArrayList();
    String sourceDir;
    DmcUncheckedOIFParser parser = new DmcUncheckedOIFParser(this);

    public MetaGenerator() {
        this.parser.addPreserveNewlinesAttribute("description");
    }

    public void run(String[] args) throws DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        try {
            String str;
            FileUpdateManager.instance().generationStarting();
            FileUpdateManager.instance().reportProgress(System.out);
            FileUpdateManager.instance().reportErrors(System.err);
            FileUpdateManager.instance().deleteFiles(false);
            File curr = new File(".");
            this.sourceDir = curr.getCanonicalPath() + METADIR;
            this.LGPL = new StringBuffer();
            LineNumberReader in = new LineNumberReader(new FileReader(this.sourceDir + "/LGPL.txt"));
            while ((str = in.readLine()) != null) {
                this.LGPL.append(str + "\n");
            }
            in.close();
            this.parser.parseFile(this.sourceDir + "/metaSchema.dms");
            this.createInternalTypesForComplexTypes();
            this.dumpTypeIterables(curr.getCanonicalPath() + DMWDIR);
            this.createInternalReferenceTypes();
            this.dumpDerivedTypes(curr.getCanonicalPath() + TYPEDIR);
            Iterator<DmcUncheckedObject> enums = this.enumDefs.values().iterator();
            while (enums.hasNext()) {
                this.dumpEnumClass(curr.getCanonicalPath() + ENUMDIR, enums.next());
            }
            this.dumpDmcTypes(curr.getCanonicalPath() + TYPEDIR);
            this.dumpComplexTypes(curr.getCanonicalPath() + TYPEDIR);
            this.dumpDMOClasses(curr.getCanonicalPath() + DMODIR);
            DmoCompactSchemaFormatter csf = new DmoCompactSchemaFormatter(System.out);
            csf.dumpSchema("meta", "org.dmd.dms", this.classDefs, this.attributeDefs, this.typeDefs, this.ruleInstances, curr.getCanonicalPath() + DMODIR, 0, 200);
            RuleFormatter rf = new RuleFormatter(System.out);
            rf.dumpRuleCategoryInterfaces("meta", "org.dmd.dms", this.ruleCategoryDefs, curr.getCanonicalPath() + RULESDIR);
            this.dumpDMWClasses(curr.getCanonicalPath() + DMWDIR);
            this.dumpMetaSchemaNew(curr.getCanonicalPath() + DMSDIR);
            FileUpdateManager.instance().generationComplete();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (ResultException ex) {
            System.err.println(ex);
        }
    }

    void createClassesFromDMDefinitionModules() {
    }

    void dumpMetaSchemaNew(String od) throws IOException, ResultException {
        ManagedFileWriter out = null;
        ImportManager imports = new ImportManager();
        imports.addImport("org.dmd.dmc.DmcValueException", "To handle potential value exceptions.");
        imports.addImport("org.dmd.dms.generated.dmo.*", "Access to meta schema DMOs");
        out = FileUpdateManager.instance().getWriter(od, "MetaSchemaAG.java");
        out.write(this.LGPL.toString());
        out.write("package org.dmd.dms;\n\n");
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("/**\n");
        out.write("  * This class creates the basic definitions that allow for the definition of schemas.\n");
        out.write("  * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("  */\n");
        out.write("abstract public class MetaSchemaAG extends SchemaDefinition {\n");
        this.dumpStaticDefinitions(out);
        out.write("    public MetaSchemaAG() throws DmcValueException {\n\n");
        out.write("        super(\"meta\");\n\n");
        out.write("        // We only ever want to initialize the schema once, so check\n");
        out.write("        // to see if we've initialized the first class definition\n");
        out.write("        if (_metaSchema == null){\n");
        out.write("            _metaSchema = this;\n");
        out.write("            staticRefName = new String(\"MetaSchema._\");\n\n");
        out.write("            this.addDescription(\"The meta schema defines the elements used to define schemas.\");\n");
        out.write("            this.setDotName(\"meta.SchemaDefinition\");\n");
        out.write("            this.setSchemaPackage(\"org.dmd.dms\");\n");
        out.write("            this.setDmwPackage(\"org.dmd.dms\");\n");
        out.write("            this.setSchemaBaseID(0);\n");
        out.write("            this.setSchemaIDRange(200);\n");
        out.write("            initClasses();\n");
        out.write("            initAttributes();\n");
        out.write("            initTypes();\n");
        out.write("            initEnums();\n");
        out.write("            initRuleCategories();\n");
        out.write("            initComplexTypes();\n");
        out.write("        }\n");
        out.write("    }\n");
        this.dumpInitClasses(out);
        this.dumpInitAttributes(out);
        this.dumpInitTypes(out);
        this.dumpInitEnums(out);
        this.dumpInitRuleCategories(out);
        this.dumpInitComplexTypes(out);
        out.write("}\n");
        ((BufferedWriter)out).close();
    }

    void dumpStaticDefinitions(BufferedWriter out) throws IOException {
        int i;
        out.write("    public static SchemaDefinition    _metaSchema;\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderClasses.size(); ++i) {
            out.write("    public static ClassDefinition     _" + this.origOrderClasses.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderEnums.size(); ++i) {
            out.write("    public static EnumDefinition      _" + this.origOrderEnums.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderTypes.size(); ++i) {
            DmcUncheckedObject td = this.typeDefs.get(this.origOrderTypes.get(i));
            String internallyGenerated = td.getSV("internallyGenerated");
            if (internallyGenerated != null) continue;
            out.write("    public static TypeDefinition      _" + this.origOrderTypes.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderAttrs.size(); ++i) {
            out.write("    public static AttributeDefinition _" + this.origOrderAttrs.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderComplexTypes.size(); ++i) {
            out.write("    public static ComplexTypeDefinition _" + this.origOrderComplexTypes.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderCategories.size(); ++i) {
            out.write("    public static RuleCategory        _" + this.origOrderCategories.get(i) + ";\n");
        }
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (i = 0; i < this.origOrderRules.size(); ++i) {
            out.write("    public static RuleDefinition      _" + this.origOrderRules.get(i) + ";\n");
        }
        out.write("\n");
    }

    void dumpInitClasses(BufferedWriter out) throws IOException {
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initClasses() throws DmcValueException {\n\n");
        for (String cn : this.origOrderClasses) {
            DmcUncheckedObject classDef = this.classDefs.get(cn);
            String name = classDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        ClassDefinitionDMO " + dmoName + " = new ClassDefinitionDMO();\n");
            out.write("        _" + name + " = new ClassDefinition(" + dmoName + ",MetaDMSAG.__" + name + ");\n");
            this.dumpAttrValues("        ", dmoName, classDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addClassDefList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpInitAttributes(BufferedWriter out) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initAttributes() throws DmcValueException {\n\n");
        for (DmcUncheckedObject attrDef : this.attributeDefs.values()) {
            String name = attrDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        AttributeDefinitionDMO " + dmoName + " = new AttributeDefinitionDMO();\n");
            out.write("        _" + name + " = new AttributeDefinition(" + dmoName + ");\n");
            this.dumpAttrValues("        ", dmoName, attrDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addAttributeDefList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpInitTypes(BufferedWriter out) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initTypes() throws DmcValueException {\n\n");
        for (DmcUncheckedObject typeDef : this.typeDefs.values()) {
            String internallyGenerated = typeDef.getSV("internallyGenerated");
            if (internallyGenerated != null) continue;
            String name = typeDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        TypeDefinitionDMO " + dmoName + " = new TypeDefinitionDMO();\n");
            out.write("        _" + name + " = new TypeDefinition(" + dmoName + ");\n");
            this.dumpAttrValues("        ", dmoName, typeDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addTypeDefList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpInitEnums(BufferedWriter out) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initEnums() throws DmcValueException {\n\n");
        for (DmcUncheckedObject enumDef : this.enumDefs.values()) {
            String name = enumDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        EnumDefinitionDMO " + dmoName + " = new EnumDefinitionDMO();\n");
            out.write("        _" + name + " = new EnumDefinition(" + dmoName + ");\n");
            this.dumpAttrValues("        ", dmoName, enumDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addEnumDefList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpInitRuleCategories(BufferedWriter out) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initRuleCategories() throws DmcValueException {\n\n");
        for (DmcUncheckedObject catDef : this.ruleCategoryDefs.values()) {
            String name = catDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        RuleCategoryDMO " + dmoName + " = new RuleCategoryDMO();\n");
            out.write("        _" + name + " = new RuleCategory(" + dmoName + ");\n");
            this.dumpAttrValues("        ", dmoName, catDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addRuleCategoryList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpInitComplexTypes(BufferedWriter out) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initComplexTypes() throws DmcValueException {\n\n");
        for (DmcUncheckedObject ctypeDef : this.complexTypeDefs.values()) {
            String name = ctypeDef.getSV("name");
            String dmoName = "_" + name + "OBJ";
            out.write("        ComplexTypeDefinitionDMO " + dmoName + " = new ComplexTypeDefinitionDMO();\n");
            out.write("        _" + name + " = new ComplexTypeDefinition(" + dmoName + ");\n");
            this.dumpAttrValues("        ", dmoName, ctypeDef, out);
            out.write("        _" + name + ".setDefinedIn(this);\n");
            out.write("        addComplexTypeDefList(_" + name + ");\n");
            out.write("\n");
        }
        out.write("    }\n");
    }

    void dumpAttrValues(String prefix, String dmoName, DmcUncheckedObject obj, BufferedWriter out) throws IOException {
        Iterator<String> names = obj.getAttributeNames();
        if (names == null) {
            return;
        }
        while (names.hasNext()) {
            String isRefType;
            String an = names.next();
            if (an.equals("requiredPart")) {
                DebugInfo.debug("HERE");
            }
            String anCapped = Manipulator.capFirstChar(an);
            DmcUncheckedObject attrDef = this.attributeDefs.get(an);
            String valueType = attrDef.getSV("valueType");
            boolean sv = true;
            String type = attrDef.getSV("type") + "REF";
            DmcUncheckedObject typeDef = this.typeDefs.get(type);
            boolean isReference = false;
            if (typeDef != null && (isRefType = typeDef.getSV("isRefType")) != null) {
                isReference = true;
            }
            if (valueType != null && valueType.equals("MULTI")) {
                sv = false;
            }
            if (sv) {
                if (an.equals("description")) {
                    String fixed = obj.getSV(an).replaceAll("\n", "\\\\n");
                    out.write(prefix + dmoName + ".set" + anCapped + "(\"" + fixed + "\");\n");
                    continue;
                }
                if (isReference) {
                    out.write(prefix + dmoName + ".set" + anCapped + "(\"meta." + obj.getSV(an) + "\");\n");
                    continue;
                }
                out.write(prefix + dmoName + ".set" + anCapped + "(\"" + obj.getSV(an) + "\");\n");
                continue;
            }
            NamedStringArray values = obj.get(an);
            for (String value : values) {
                if (value.indexOf("\"") != -1) {
                    value = value.replaceAll("\"", "\\\\\"");
                }
                if (isReference) {
                    out.write(prefix + dmoName + ".add" + anCapped + "(\"meta." + value + "\");\n");
                    continue;
                }
                out.write(prefix + dmoName + ".add" + anCapped + "(\"" + value + "\");\n");
            }
        }
    }

    void dumpComplexTypes(String typedir) throws ResultException, IOException, DmcValueException {
        for (DmcUncheckedObject typedef : this.complexTypeDefs.values()) {
            this.dumpComplexType(typedir, typedef);
        }
    }

    void dumpDerivedTypes(String typedir) throws ResultException, IOException {
        for (DmcUncheckedObject typedef : this.typeDefs.values()) {
            DmcUncheckedObject attrDef;
            String genericArgs = typedef.getSV("genericArgs");
            String keyClass = typedef.getSV("keyClass");
            String keyImport = typedef.getSV("keyImport");
            if (genericArgs == null) {
                genericArgs = "";
            }
            String nt = typedef.getSV("isNameType");
            String ft = typedef.getSV("isFilterType");
            boolean nameType = false;
            boolean filterType = false;
            if (nt != null) {
                nameType = true;
            }
            if (ft != null) {
                filterType = true;
            }
            if (typedef.getSV("isEnumType") != null) {
                String tmp = typedef.getSV("name");
                int refPos = tmp.indexOf("REF");
                String tn = tmp.substring(0, refPos);
                GenUtility.dumpSVType(typedir, "org.dmd.dms", null, tn, "org.dmd.dms.generated.enums." + tn, null, null, null, genericArgs, false, nameType, false, this.LGPL.toString(), System.out);
                GenUtility.dumpMVType(typedir, "org.dmd.dms", null, tn, "org.dmd.dms.generated.enums." + tn, null, null, genericArgs, false, this.LGPL.toString(), System.out);
                GenUtility.dumpSETType(typedir, "org.dmd.dms", null, tn, "org.dmd.dms.generated.enums." + tn, null, null, genericArgs, false, this.LGPL.toString(), System.out);
                if (keyClass == null) continue;
                GenUtility.dumpMAPType(typedir, "org.dmd.dms", null, tn, "org.dmd.dms.generated.enums." + tn, null, null, genericArgs, keyClass, keyImport, this.LGPL.toString(), System.out);
                continue;
            }
            if (typedef.getSV("isRefType") != null) {
                String tn = typedef.getSV("originalClass") + "REF";
                GenUtility.dumpSVType(typedir, "org.dmd.dms", null, tn, null, "org.dmd.dmc.types.DefinitionName", "DefinitionName", null, genericArgs, true, nameType, false, this.LGPL.toString(), System.out);
                GenUtility.dumpMVType(typedir, "org.dmd.dms", null, tn, null, "org.dmd.dmc.types.DefinitionName", "DefinitionName", genericArgs, true, this.LGPL.toString(), System.out);
                GenUtility.dumpSETType(typedir, "org.dmd.dms", null, tn, null, "org.dmd.dmc.types.DefinitionName", "DefinitionName", genericArgs, true, this.LGPL.toString(), System.out);
                if (keyClass == null) continue;
                GenUtility.dumpMAPType(typedir, "org.dmd.dms", null, tn, null, "org.dmd.dmc.types.DefinitionName", "DefinitionName", genericArgs, keyClass, keyImport, this.LGPL.toString(), System.out);
                continue;
            }
            String nameAttrID = null;
            String isNameType = typedef.getSV("isNameType");
            String isFilterType = typedef.getSV("isFilterType");
            if (isNameType != null) {
                String nameAttributeDef = typedef.getSV("nameAttributeDef");
                attrDef = this.attributeDefs.get(nameAttributeDef);
                nameAttrID = attrDef.getSV("dmdID");
            }
            if (isFilterType != null) {
                String filterAttributeDef = typedef.getSV("filterAttributeDef");
                attrDef = this.attributeDefs.get(filterAttributeDef);
                nameAttrID = attrDef.getSV("dmdID");
            }
            GenUtility.dumpSVType(typedir, "org.dmd.dms", typedef.getSV("primitiveType"), typedef.getSV("name"), typedef.getSV("typeClassName"), null, null, nameAttrID, genericArgs, false, nameType, filterType, this.LGPL.toString(), System.out);
            GenUtility.dumpMVType(typedir, "org.dmd.dms", typedef.getSV("primitiveType"), typedef.getSV("name"), typedef.getSV("typeClassName"), null, null, genericArgs, false, this.LGPL.toString(), System.out);
            GenUtility.dumpSETType(typedir, "org.dmd.dms", typedef.getSV("primitiveType"), typedef.getSV("name"), typedef.getSV("typeClassName"), null, null, genericArgs, false, this.LGPL.toString(), System.out);
            if (keyClass == null) continue;
            GenUtility.dumpMAPType(typedir, "org.dmd.dms", typedef.getSV("typeClassName"), typedef.getSV("name"), typedef.getSV("primitiveType"), null, null, genericArgs, keyClass, keyImport, this.LGPL.toString(), System.out);
        }
    }

    void dumpTypeIterables(String dmwdir) throws ResultException, IOException {
        for (DmcUncheckedObject typedef : this.typeDefs.values()) {
            String tn = typedef.getSV("name");
            String ti = typedef.getSV("primitiveType");
            String genericArgs = typedef.getSV("genericArgs");
            GenUtility.dumpIterable(dmwdir, "org.dmd.dms", ti, tn, genericArgs, this.LGPL.toString(), System.out);
        }
    }

    @Override
    public void handleObject(DmcUncheckedObject obj, String infile, int lineNumber) throws ResultException {
        String objClass = obj.classes.get(0);
        obj.addValue("file", "metaSchema.dms");
        obj.addValue("lineNumber", lineNumber + "");
        String name = obj.getSV("name");
        if (name == null) {
            if (this.classDefs.get(objClass) != null) {
                DebugInfo.debug("HAVE A RULE INSTANCE");
                this.ruleInstances.add(obj);
                return;
            }
            ResultException ex = new ResultException("No name for object: " + objClass);
            ex.result.lastResult().lineNumber(obj.lineNumber);
            throw ex;
        }
        obj.addValue("dotName", "meta." + name + "." + obj.getConstructionClass());
        if (objClass.equals("TypeDefinition")) {
            this.typeDefs.put(name, obj);
            this.origOrderTypes.add(name);
        } else if (objClass.equals("EnumDefinition")) {
            this.enumDefs.put(name, obj);
            this.origOrderEnums.add(name);
        } else if (objClass.equals("AttributeDefinition")) {
            DmcUncheckedObject typeDef;
            String type;
            this.attributeDefs.put(name, obj);
            this.origOrderAttrs.add(name);
            String designatedNameAttribute = obj.getSV("designatedNameAttribute");
            String designatedFilterAttribute = obj.getSV("designatedFilterAttribute");
            if (designatedNameAttribute != null) {
                type = obj.getSV("type");
                typeDef = this.typeDefs.get(type);
                typeDef.addValue("nameAttributeDef", name);
            }
            if (designatedFilterAttribute != null) {
                type = obj.getSV("type");
                typeDef = this.typeDefs.get(type);
                typeDef.addValue("filterAttributeDef", name);
            }
        } else if (objClass.equals("ClassDefinition")) {
            this.classDefs.put(name, obj);
            this.origOrderClasses.add(name);
        } else if (objClass.equals("ComplexTypeDefinition")) {
            this.complexTypeDefs.put(name, obj);
            this.origOrderComplexTypes.add(name);
        } else if (objClass.equals("AttributeValidatorDefinition")) {
            this.avDefs.put(name, obj);
            this.origOrderAVDs.add(name);
        } else if (objClass.equals("ObjectValidatorDefinition")) {
            this.ovDefs.put(name, obj);
            this.origOrderOVDs.add(name);
        } else if (objClass.equals("RuleDefinition")) {
            this.ruleDefs.put(name, obj);
            this.origOrderRules.add(name);
            this.createClassDefForRuleDef(obj);
        } else if (objClass.equals("RuleCategory")) {
            this.ruleCategoryDefs.put(name, obj);
            this.origOrderCategories.add(name);
        } else if (objClass.equals("DMDefinitionModule")) {
            this.dmModuleDefs.put(name, obj);
            this.origOrderCategories.add(name);
        } else {
            ResultException ex = new ResultException("Unknown definition type: " + objClass);
            ex.result.lastResult().lineNumber(obj.lineNumber);
        }
        this.allDefs.put(name, obj);
    }

    void createClassDefForRuleDef(DmcUncheckedObject uco) throws ResultException {
        NamedStringArray may;
        ArrayList<String> objClasses = new ArrayList<String>();
        objClasses.add("ClassDefinition");
        DmcUncheckedObject classDef = new DmcUncheckedObject(objClasses, 0);
        String name = Manipulator.capFirstChar(uco.getSV("name"));
        String isExtensible = uco.getSV("isExtensible");
        String ctype = "STRUCTURAL";
        if (isExtensible != null) {
            ctype = "EXTENSIBLE";
        }
        classDef.addValue("name", name + "Data");
        classDef.addValue("dotName", "meta." + name + "Data.ClassDefinition");
        classDef.addValue("classType", ctype);
        classDef.addValue("derivedFrom", "RuleData");
        classDef.addValue("dmdID", uco.getSV("dmdID"));
        classDef.addValue("dmoImport", "org.dmd.dms.generated.dmo." + name + "DataDMO");
        classDef.addValue("javaClass", "org.dmd.dms.generated.dmo." + name + "DataDMO");
        classDef.addValue("internallyGenerated", "true");
        classDef.addValue("ruleDefinition", name);
        classDef.addValue("must", "ruleTitle");
        classDef.addValue("may", "description");
        NamedStringArray must = uco.get("must");
        if (must != null) {
            for (String attr : must) {
                classDef.addValue("must", attr);
            }
        }
        if ((may = uco.get("may")) != null) {
            for (String attr : may) {
                classDef.addValue("may", attr);
            }
        }
        this.classDefs.put(name + "Data", classDef);
        this.origOrderClasses.add(name + "Data");
    }

    void createInternalTypesForComplexTypes() throws ResultException {
        for (DmcUncheckedObject complexTypeDef : this.complexTypeDefs.values()) {
            String cn;
            String tn = cn = complexTypeDef.getSV("name");
            ArrayList<String> objClasses = new ArrayList<String>();
            objClasses.add("TypeDefinition");
            DmcUncheckedObject typeDef = new DmcUncheckedObject(objClasses, 0);
            typeDef.addValue("name", cn);
            typeDef.addValue("dotName", "meta." + cn + ".TypeDefinition");
            typeDef.addValue("typeClassName", "org.dmd.dms.generated.types.DmcType" + cn);
            typeDef.addValue("primitiveType", "org.dmd.dms.generated.types." + cn);
            typeDef.addValue("internallyGenerated", "true");
            typeDef.addValue("description", "This is an internally generated type to represent complex type " + cn + ".");
            this.typeDefs.put(tn, typeDef);
            this.origOrderTypes.add(tn);
        }
    }

    void createInternalReferenceTypes() throws ResultException {
        String tn;
        for (DmcUncheckedObject classDef : this.classDefs.values()) {
            String cn = classDef.getSV("name");
            String isNamedBy = classDef.getSV("isNamedBy");
            tn = null;
            DmcUncheckedObject typeDef = null;
            if (isNamedBy == null) continue;
            tn = cn + "REF";
            ArrayList<String> objClasses = new ArrayList<String>();
            objClasses.add("TypeDefinition");
            typeDef = new DmcUncheckedObject(objClasses, 0);
            typeDef.addValue("name", cn + "REF");
            typeDef.addValue("dotName", "meta." + cn + "REF.TypeDefinition");
            typeDef.addValue("typeClassName", "org.dmd.dms.generated.types.DmcType" + cn + "REF");
            typeDef.addValue("wrapperClassName", classDef.getSV("javaClass"));
            typeDef.addValue("internallyGenerated", "true");
            typeDef.addValue("isRefType", "true");
            typeDef.addValue("description", "This is an internally generated type to allow references to " + cn + " objects.");
            typeDef.addValue("originalClass", cn);
            this.typeDefs.put(tn, typeDef);
            this.origOrderTypes.add(tn);
        }
        for (DmcUncheckedObject enumDef : this.enumDefs.values()) {
            String cn = enumDef.getSV("name");
            tn = cn + "REF";
            ArrayList<String> objClasses = new ArrayList<String>();
            objClasses.add("TypeDefinition");
            DmcUncheckedObject typeDef = new DmcUncheckedObject(objClasses, 0);
            typeDef.addValue("name", cn + "REF");
            typeDef.addValue("dotName", "meta." + cn + "REF.TypeDefinition");
            typeDef.addValue("enumName", cn);
            typeDef.addValue("typeClassName", "org.dmd.dms.generated.types.DmcType" + cn);
            typeDef.addValue("primitiveType", "org.dmd.dms.generated.enums." + cn);
            typeDef.addValue("internallyGenerated", "true");
            typeDef.addValue("isEnumType", "true");
            typeDef.addValue("description", "This is an internally generated type to allow references to " + cn + " objects.");
            this.typeDefs.put(tn, typeDef);
            this.origOrderTypes.add(tn);
        }
    }

    private void dumpEnumClass(String od, DmcUncheckedObject enumObj) throws IOException, ResultException, DmcValueException {
        NamedStringArray al = null;
        ManagedFileWriter enumClassDef = null;
        TreeMap<Integer, EnumValue> byId = new TreeMap<Integer, EnumValue>();
        TreeMap<String, EnumValue> byName = new TreeMap<String, EnumValue>();
        String cp = "org.dmd.dms";
        String cn = enumObj.getSV("name");
        al = enumObj.get("enumValue");
        if (al == null) {
            System.out.println("Couldn't get enumValues from:\n" + enumObj);
            return;
        }
        for (String enumValName : al) {
            EnumValue ev = new EnumValue(enumValName);
            if (byId.get(ev.getId()) != null) {
                ResultException ex = new ResultException();
                ex.addError("Duplicate enum id: " + ev.getId());
                ex.result.lastResult().lineNumber(enumObj.lineNumber);
                throw ex;
            }
            byId.put(ev.getId(), ev);
            if (byName.get(ev.getName()) != null) {
                ResultException ex = new ResultException();
                ex.addError("Duplicate enum name: " + ev.getName());
                ex.result.lastResult().lineNumber(enumObj.lineNumber);
                throw ex;
            }
            byName.put(ev.getName(), ev);
        }
        enumClassDef = FileUpdateManager.instance().getWriter(od, cn + ".java");
        enumClassDef.write(this.LGPL.toString());
        enumClassDef.write("package " + cp + ".generated.enums;\n\n");
        enumClassDef.write("import java.util.*;\n\n");
        enumClassDef.write("/**\n * The " + cn + " enumeration.\n");
        enumClassDef.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
        enumClassDef.write(" * manually.\n");
        enumClassDef.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        enumClassDef.write(" */\n");
        enumClassDef.write("public enum " + cn + "\n{\n");
        Iterator enumit = byId.values().iterator();
        while (enumit.hasNext()) {
            EnumValue ev = (EnumValue)enumit.next();
            enumClassDef.write("    /**\n");
            this.dumpCodeComment(ev.getDescription(), enumClassDef, "     * ");
            enumClassDef.write("     */\n");
            enumClassDef.write("    " + ev.getName() + "(" + ev.getId() + ")");
            if (enumit.hasNext()) {
                enumClassDef.write(",\n\n");
                continue;
            }
            enumClassDef.write(";\n\n");
        }
        enumClassDef.write("    // Maps our integer value to the enumeration value\n");
        enumClassDef.write("    private static final Map<Integer," + cn + "> lookup = new HashMap<Integer," + cn + ">();\n\n");
        enumClassDef.write("    static {\n");
        enumClassDef.write("        for(" + cn + " s : EnumSet.allOf(" + cn + ".class))\n");
        enumClassDef.write("            lookup.put(s.intValue(), s);\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("    // Maps our enumeration (string) value to the enumeration value\n");
        enumClassDef.write("    private static final Map<String," + cn + "> lookupString = new HashMap<String, " + cn + ">();\n\n");
        enumClassDef.write("    static {\n");
        enumClassDef.write("        for(" + cn + " s : EnumSet.allOf(" + cn + ".class))\n");
        enumClassDef.write("            lookupString.put(s.name(), s);\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("    // Our current value as an int - normally, this isn't available in an enum\n");
        enumClassDef.write("    private int ival;\n\n");
        enumClassDef.write("    /**\n");
        enumClassDef.write("     * This private constructor allows us to access our int value when required.\n");
        enumClassDef.write("     */\n");
        enumClassDef.write("    private " + cn + "(int i){\n");
        enumClassDef.write("        ival = i;\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("    /**\n");
        enumClassDef.write("     * Returns the value of this enum value as an int.\n");
        enumClassDef.write("     */\n");
        enumClassDef.write("    public int intValue(){\n");
        enumClassDef.write("        return(ival);\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("    /**\n");
        enumClassDef.write("     * Returns the enum value of the specified int or null if it's not valid.\n");
        enumClassDef.write("     */\n");
        enumClassDef.write("    public static " + cn + " get(int code) {\n");
        enumClassDef.write("        return(lookup.get(code));\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("    /**\n");
        enumClassDef.write("     * Returns a value for this enum or throws an exception if the String value isn't\n");
        enumClassDef.write("     * a valid member of this enum.\n");
        enumClassDef.write("     */\n");
        enumClassDef.write("    public static " + cn + " get(String str) {\n");
        enumClassDef.write("        return(lookupString.get(str));\n");
        enumClassDef.write("    }\n\n");
        enumClassDef.write("}");
        ((BufferedWriter)enumClassDef).close();
    }

    private void dumpCodeComment(String comment, BufferedWriter out, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(comment);
        try {
            while (sb.length() > 75) {
                int offset = 74;
                while (sb.charAt(offset) != ' ') {
                    --offset;
                }
                out.write(indent);
                for (int i = 0; i < offset; ++i) {
                    out.write(sb.charAt(i));
                }
                out.write("\n");
                sb.delete(0, offset + 1);
            }
            out.write(indent + sb + "\n");
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    private void dumpCodeComment(NamedStringArray namedStringArray, BufferedWriter out, String indent, String returnType) {
        StringBuffer sb = new StringBuffer();
        if (namedStringArray == null) {
            return;
        }
        for (String str : namedStringArray) {
            sb.append(str + " ");
        }
        try {
            while (sb.length() > 75) {
                int offset = 74;
                while (sb.charAt(offset) != ' ') {
                    --offset;
                }
                out.write(indent);
                for (int i = 0; i < offset; ++i) {
                    out.write(sb.charAt(i));
                }
                out.write("\n");
                sb.delete(0, offset + 1);
            }
            out.write(indent + sb + "\n");
            if (returnType != null) {
                out.write(indent + "@return the " + returnType + "\n");
            }
        }
        catch (IOException e) {
            System.out.println("IO Error:\n" + e);
        }
    }

    private void dumpDMWClasses(String dmwdir) throws ResultException {
        for (int i = 0; i < this.origOrderClasses.size(); ++i) {
            DmcUncheckedObject go = this.classDefs.get(this.origOrderClasses.get(i));
            String derivedFrom = go.getSV("derivedFrom");
            String isNamedBy = go.getSV("isNamedBy");
            String isDSDefinition = go.getSV("isDSDefinition");
            String isDSModule = go.getSV("isDSModule");
            String cn = go.getSV("name");
            if (cn == null) {
                System.out.println("Couldn't get name for class definition:\n" + go);
                continue;
            }
            try {
                String classType;
                String baseClass;
                ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmwdir, cn + "DMW.java");
                out.write(this.LGPL.toString());
                out.write("package org.dmd.dms.generated.dmw;\n\n");
                ImportManager imports = new ImportManager();
                imports.addImport("java.util.*", "To support access functions");
                imports.addImport("org.dmd.dmc.types.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                imports.addImport("org.dmd.dmc.*", "Basic dark-matter infrastructure");
                imports.addImport("org.dmd.dmw.*", "Base wrapper capabilities");
                imports.addImport("org.dmd.dms.generated.dmo.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                imports.addImport("org.dmd.dms.generated.enums.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                imports.addImport("org.dmd.dms.generated.types.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                imports.addImport("org.dmd.util.exceptions.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                imports.addImport("org.dmd.dms.*", "Blanket import because at the meta level it's tricky to determine the exact pieces we need");
                if (cn.equals("EnumDefinition")) {
                    imports.addImport("org.dmd.dms.types.*", "Required for EnumDefinition");
                }
                if (isDSDefinition != null) {
                    imports.addImport("org.dmd.dmc.definitions.DmcDefinitionIF", "Because this is a DS definition");
                }
                if (isDSModule != null) {
                    imports.addImport("org.dmd.dmc.definitions.DmcModuleIF", "Because this is a DS module");
                }
                if (cn.equals("ActionTriggerInfo")) {
                    imports.addImport("org.dmd.dms.extended.ActionTriggerInfo", "A hack that should go away! ");
                }
                out.write("\n");
                out.write(imports.getFormattedImports());
                out.write("/**\n");
                this.dumpCodeComment(go.get("description"), out, " * ", null);
                out.write(" * @author Auto Generated\n");
                out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write(" */\n");
                out.write("@SuppressWarnings(\"unused\")\n");
                String additionalInterfaces = "";
                if (isDSDefinition != null) {
                    additionalInterfaces = " implements DmcDefinitionIF";
                }
                if (isDSModule != null) {
                    additionalInterfaces = " implements DmcModuleIF";
                }
                if (derivedFrom == null) {
                    baseClass = "DmwWrapper" + additionalInterfaces;
                    if (isNamedBy != null) {
                        baseClass = "DmwNamedObjectWrapper" + additionalInterfaces;
                    }
                } else {
                    DmcUncheckedObject bc = this.classDefs.get(derivedFrom);
                    if (bc == null) {
                        ResultException ex = new ResultException();
                        ex.addError("Unknown base class: " + derivedFrom + " for class: " + cn);
                        ex.result.lastResult().lineNumber(go.lineNumber);
                        throw ex;
                    }
                    baseClass = bc.getSV("javaClass") + additionalInterfaces;
                }
                if ((classType = go.getSV("classType")).equals("ABSTRACT")) {
                    out.write("public abstract class " + cn + "DMW extends " + baseClass + " {\n\n");
                } else if (cn.equals("SchemaDefinition")) {
                    out.write("public abstract class " + cn + "DMW extends " + baseClass + " {\n\n");
                } else {
                    out.write("public class " + cn + "DMW extends " + baseClass + " {\n\n");
                }
                out.write("    private " + cn + "DMO mycore;\n\n");
                out.write("    protected " + cn + "DMW() {\n");
                out.write("        super(new " + cn + "DMO());\n");
                out.write("        mycore = (" + cn + "DMO) core;\n");
                out.write("        mycore.setContainer(this);\n");
                out.write("    }\n\n");
                out.write("    protected " + cn + "DMW(DmcObject obj) {\n");
                out.write("        super(obj);\n");
                out.write("        mycore = (" + cn + "DMO) core;\n");
                out.write("        mycore.setContainer(this);\n");
                out.write("    }\n\n");
                out.write("    protected " + cn + "DMW(DmcObject obj, ClassDefinition cd) {\n");
                out.write("        super(obj,cd);\n");
                out.write("        mycore = (" + cn + "DMO) core;\n");
                out.write("        mycore.setContainer(this);\n");
                out.write("    }\n\n");
                out.write("    @Override\n");
                out.write("    public void setDmcObject(DmcObject obj) {\n");
                out.write("        core   = obj;\n");
                out.write("        mycore = (" + cn + "DMO) obj;\n");
                out.write("        obj.setContainer(this);\n");
                out.write("    }\n\n");
                out.write("    public  " + cn + "DMO getDMO() {\n");
                out.write("        return(mycore);\n");
                out.write("    }\n\n");
                if (derivedFrom != null && derivedFrom.equals("DmsDefinition")) {
                    out.write("    protected " + cn + "DMW(ClassDefinition cd) {\n");
                    out.write("        super(cd);\n");
                    out.write("    }\n\n");
                    out.write("    protected " + cn + "DMW(String mn) throws DmcValueException {\n");
                    out.write("        super(new " + cn + "DMO());\n");
                    out.write("        mycore = (" + cn + "DMO) core;\n");
                    out.write("        mycore.setContainer(this);\n");
                    out.write("        mycore.setName(mn);\n");
                    out.write("        metaname = mn;\n");
                    out.write("    }\n\n");
                }
                NamedStringArray must = go.get("must");
                NamedStringArray may = go.get("may");
                ArrayList<String> atlist = new ArrayList<String>();
                if (must != null) {
                    for (String attrName : must) {
                        atlist.add(attrName);
                    }
                }
                if (may != null) {
                    for (String attrName : may) {
                        atlist.add(attrName);
                    }
                }
                for (int j = 0; j < atlist.size(); ++j) {
                    String currAttr = ((String)atlist.get(j)).trim();
                    out.write("    /**\n");
                    DmcUncheckedObject attrObj = this.attributeDefs.get(currAttr.trim());
                    if (attrObj == null) {
                        System.err.println("Missing attribute definition for: " + currAttr.trim() + " in class definition: " + cn);
                        System.exit(1);
                    }
                    String multiValued = attrObj.getSV("valueType");
                    DmcUncheckedObject attributeDef = this.attributeDefs.get(currAttr);
                    this.dumpCodeComment(attrObj.get("description"), out, "     * ", attributeDef.getSV("type"));
                    if (multiValued != null) {
                        this.dumpMVAccessFunction(out, currAttr, false, cn + "DMO");
                        continue;
                    }
                    out.write("     */\n");
                    this.dumpSVAccessFunction(out, currAttr, false, cn + "DMO");
                }
                out.write("\n");
                if (isNamedBy != null) {
                    String nameType = "DefinitionName";
                    if (cn.equals("RuleData")) {
                        nameType = "RuleName";
                    }
                    out.write("    ////////////////////////////////////////////////////////////////////////////////\n");
                    out.write("    // DmcNamedObjectIF implementation\n");
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n\n");
                    out.write("    /**\n");
                    out.write("     * @return The name of this object from the " + isNamedBy + " attribute.\n");
                    out.write("     */\n");
                    out.write("    public " + nameType + " getObjectName(){\n");
                    out.write("        return(mycore.getObjectName());\n");
                    out.write("    }\n\n");
                    out.write("\n");
                    out.write("    /**\n");
                    out.write("     * @return The " + isNamedBy + " attribute.\n");
                    out.write("     */\n");
                    out.write("    public DmcAttribute<?> getObjectNameAttribute(){\n");
                    out.write("        return(mycore.getObjectNameAttribute());\n");
                    out.write("    }\n\n");
                }
                out.write("}\n");
                ((BufferedWriter)out).close();
                if (isNamedBy == null) continue;
                GenUtility.dumpIterableREF(dmwdir, "org.dmd.dms", cn, true, "org.dmd.dms", this.LGPL.toString(), System.out);
                continue;
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
            }
        }
    }

    private void dumpDMOClasses(String od) throws ResultException {
        boolean isDmsDefinition = false;
        for (int i = 0; i < this.origOrderClasses.size(); ++i) {
            DmcUncheckedObject go = this.classDefs.get(this.origOrderClasses.get(i));
            TreeSet<String> must = new TreeSet<String>();
            TreeSet<String> may = new TreeSet<String>();
            String derivedFrom = go.getSV("derivedFrom");
            String isNamedBy = go.getSV("isNamedBy");
            String isDSDefinition = go.getSV("isDSDefinition");
            String cn = go.getSV("name");
            if (cn == null) {
                System.out.println("Couldn't get name for class definition:\n" + go);
                continue;
            }
            try {
                String baseClass;
                ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, cn + "DMO.java");
                out.write(this.LGPL.toString());
                out.write("package org.dmd.dms.generated.dmo;\n\n");
                ImportManager imports = new ImportManager();
                imports.addImport("java.io.Serializable", "Serializable marker interface");
                imports.addImport("java.util.*", "Attribute info support");
                boolean needBasicTypes = this.getAllMustAndMay(go, must, may);
                if (!cn.equals("DmwWrapper") && needBasicTypes) {
                    imports.addImport("org.dmd.dmc.types.*", "Basic type access");
                }
                if (cn.endsWith("RuleData")) {
                    imports.addImport("org.dmd.dmc.types.*", "Basic type access");
                }
                imports.addImport("org.dmd.dmc.*", "Dark matter core");
                if (cn.equals("EnumDefinition")) {
                    imports.addImport("org.dmd.dms.types.*", "Enum support");
                }
                if (isDSDefinition != null) {
                    imports.addImport("org.dmd.dmc.definitions.DmcDefinitionIF", "This is a domain specific definition");
                }
                imports.addImport("org.dmd.dms.generated.types.*", "Generated type access");
                if (this.hasAnyEnumAttributes(go)) {
                    imports.addImport("org.dmd.dms.generated.enums.*", "Has enum attributes");
                }
                out.write(imports.getFormattedImports() + "\n");
                out.write("\n");
                out.write("/**\n");
                this.dumpCodeComment(go.get("description"), out, " * ", null);
                out.write(" * @author Auto Generated\n");
                out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write(" */\n");
                out.write("@SuppressWarnings(\"serial\")\n");
                String additionalInterfaces = " ";
                if (isDSDefinition != null) {
                    additionalInterfaces = ", DmcDefinitionIF";
                }
                if (derivedFrom == null) {
                    baseClass = isNamedBy == null ? "DmcObject implements Serializable" + additionalInterfaces : "DmcObject implements DmcNamedObjectIF, Serializable" + additionalInterfaces;
                } else {
                    DmcUncheckedObject bc = this.classDefs.get(derivedFrom);
                    if (bc == null) {
                        ResultException ex = new ResultException();
                        ex.addError("Unknown base class: " + derivedFrom + " for class: " + cn);
                        ex.result.lastResult().lineNumber(go.lineNumber);
                        throw ex;
                    }
                    baseClass = bc.getSV("dmoImport") + " implements Serializable" + additionalInterfaces;
                }
                out.write("public class " + cn + "DMO extends " + baseClass + " {\n\n");
                ArrayList<String> atlist = new ArrayList<String>();
                if (must != null) {
                    for (String attrName : must) {
                        atlist.add(attrName);
                    }
                }
                if (may != null) {
                    for (String attrName : may) {
                        atlist.add(attrName);
                    }
                }
                out.write("\n\n");
                out.write("    static Map<Integer,DmcAttributeInfo> _ImAp;\n\n");
                out.write("    static Map<String ,DmcAttributeInfo> _SmAp;\n\n");
                out.write("\n");
                out.write("    static {\n");
                out.write("        _ImAp = new HashMap<Integer,DmcAttributeInfo>();\n");
                for (String n : atlist) {
                    out.write("        _ImAp.put(MetaDMSAG.__" + n + ".id,MetaDMSAG.__" + n + ");\n");
                }
                out.write("\n");
                out.write("        _SmAp = new HashMap<String ,DmcAttributeInfo>();\n");
                for (String n : atlist) {
                    out.write("        _SmAp.put(MetaDMSAG.__" + n + ".name,MetaDMSAG.__" + n + ");\n");
                }
                out.write("    }\n");
                out.write("\n\n");
                out.write("    public " + cn + "DMO(){\n");
                out.write("        super(\"" + cn + "\");\n");
                out.write("    }\n\n");
                out.write("    public " + cn + "DMO(String oc){\n");
                out.write("        super(oc);\n");
                out.write("    }\n\n");
                out.write("    public Map<Integer,DmcAttributeInfo> getIdToAttrInfo(){\n");
                out.write("        return(_ImAp);\n");
                out.write("    }\n\n");
                out.write("    public Map<String,DmcAttributeInfo> getStringToAttrInfo(){\n");
                out.write("        return(_SmAp);\n");
                out.write("    }\n\n");
                out.write("    @Override\n");
                out.write("    public " + cn + "DMO getNew(){\n");
                out.write("        " + cn + "DMO rc = new " + cn + "DMO();\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
                out.write("    @Override\n");
                out.write("    public " + cn + "DMO getSlice(DmcSliceInfo info){\n");
                out.write("        " + cn + "DMO rc = new " + cn + "DMO();\n");
                out.write("        populateSlice(rc,info);\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
                if (isDmsDefinition) {
                    out.write("     public String getConstructionClassName(){\n");
                    out.write("         return(\"" + cn + "\");\n");
                    out.write("     }\n\n");
                }
                for (int j = 0; j < atlist.size(); ++j) {
                    String currAttr = ((String)atlist.get(j)).trim();
                    out.write("    /**\n");
                    DmcUncheckedObject attrObj = this.attributeDefs.get(currAttr.trim());
                    if (attrObj == null) {
                        System.err.println("Missing attribute definition for: " + currAttr.trim() + " in class definition: " + cn);
                        System.exit(1);
                    }
                    String multiValued = attrObj.getSV("valueType");
                    DmcUncheckedObject attributeDef = this.attributeDefs.get(currAttr);
                    this.dumpCodeComment(attrObj.get("description"), out, "     * ", attributeDef.getSV("type"));
                    if (multiValued != null) {
                        this.dumpMVAccessFunction(out, currAttr, true, cn + "DMO");
                        continue;
                    }
                    out.write("     */\n");
                    this.dumpSVAccessFunction(out, currAttr, true, cn + "DMO");
                }
                out.write("\n");
                if (isNamedBy != null) {
                    String nameType = "DefinitionName";
                    if (cn.equals("RuleData")) {
                        nameType = "RuleName";
                    }
                    out.write("    ////////////////////////////////////////////////////////////////////////////////\n");
                    out.write("    // DmcNamedObjectIF implementation\n");
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n\n");
                    out.write("    /**\n");
                    out.write("     * @return The name of this object from the " + isNamedBy + " attribute.\n");
                    out.write("     */\n");
                    out.write("    @Override\n");
                    out.write("    public " + nameType + " getObjectName(){\n");
                    out.write("        DmcType" + nameType + " attr = (DmcType" + nameType + ") get(MetaDMSAG.__" + isNamedBy + ");\n");
                    out.write("        if (attr == null)\n");
                    out.write("            return(null);\n");
                    out.write("        return(attr.getSV());\n");
                    out.write("    }\n\n");
                    out.write("\n");
                    out.write("    /**\n");
                    out.write("     * @return The " + isNamedBy + " attribute.\n");
                    out.write("     */\n");
                    out.write("    @Override\n");
                    out.write("    public DmcAttribute<?> getObjectNameAttribute(){\n");
                    out.write("        DmcAttribute<?> attr = (DmcType" + nameType + ") get(MetaDMSAG.__" + isNamedBy + ");\n");
                    out.write("        return(attr);\n");
                    out.write("    }\n\n");
                }
                out.write("}\n");
                ((BufferedWriter)out).close();
                continue;
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
            }
        }
    }

    public boolean getAllMustAndMay(DmcUncheckedObject uco, TreeSet<String> must, TreeSet<String> may) throws ResultException {
        NamedStringArray mayAttr;
        NamedStringArray mustAttr;
        String derivedFrom = uco.getSV("derivedFrom");
        boolean needPrimitiveTypeImport = false;
        if (derivedFrom != null) {
            DmcUncheckedObject base = this.classDefs.get(derivedFrom);
            this.getAllMustAndMay(base, must, may);
        }
        if ((mustAttr = uco.get("must")) != null) {
            for (String name : mustAttr) {
                String primitiveType;
                must.add(name);
                DmcUncheckedObject attrDef = this.attributeDefs.get(name);
                String attrType = attrDef.getSV("type");
                DmcUncheckedObject typeDef = this.typeDefs.get(attrType);
                if (typeDef == null || (primitiveType = typeDef.getSV("primitiveType")) == null || !primitiveType.startsWith("org.dmd.dmc.types")) continue;
                needPrimitiveTypeImport = true;
            }
        }
        if ((mayAttr = uco.get("may")) != null) {
            for (String name : mayAttr) {
                String primitiveType;
                String attrType;
                DmcUncheckedObject typeDef;
                may.add(name);
                DmcUncheckedObject attrDef = this.attributeDefs.get(name);
                if (attrDef == null) {
                    System.err.println("Couldn't find attribute definition for: " + name + " while getAllMustAndMay() for: \n\n" + uco.toOIF());
                }
                if ((typeDef = this.typeDefs.get(attrType = attrDef.getSV("type"))) == null || (primitiveType = typeDef.getSV("primitiveType")) == null || !primitiveType.startsWith("org.dmd.dmc.types")) continue;
                needPrimitiveTypeImport = true;
            }
        }
        return needPrimitiveTypeImport;
    }

    void dumpSVAccessFunction(BufferedWriter out, String attrname, boolean DMO, String dmoClass) throws IOException, ResultException {
        int lastPeriod;
        DmcUncheckedObject attributeDef = this.attributeDefs.get(attrname);
        String typeName = attributeDef.getSV("type");
        boolean isObjREF = false;
        if (typeName == null) {
            ResultException ex = new ResultException();
            ex.addError("No type specified for attribute: " + attrname);
            ex.result.lastResult().lineNumber(attributeDef.lineNumber);
            throw ex;
        }
        DmcUncheckedObject typeDef = this.typeDefs.get(typeName);
        if (typeDef == null) {
            typeDef = this.enumDefs.get(typeName);
        }
        if (typeDef == null) {
            typeDef = this.classDefs.get(typeName);
            if (typeDef != null) {
                // empty if block
            }
            isObjREF = true;
        }
        if (typeDef == null) {
            ResultException ex = new ResultException();
            ex.addError("Unknown type: " + typeName + " for attribute: " + attrname);
            ex.result.lastResult().lineNumber(attributeDef.lineNumber);
            throw ex;
        }
        String typeClassName = typeDef.getSV("typeClassName");
        String attrType = "DmcType" + typeName;
        if (isObjREF) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        attrType = attrType + "SV";
        StringBuffer functionName = new StringBuffer();
        functionName.append(attrname);
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        if (DMO) {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (isObjREF) {
                out.write("    public " + typeName + "REF get" + functionName + "(){\n");
            } else {
                out.write("    public " + typeName + " get" + functionName + "(){\n");
            }
            out.write("        " + attrType + " attr = (" + attrType + ") get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            String nullReturnValue = typeDef.getSV("nullReturnValue");
            String attrNulReturnValue = attributeDef.getSV("nullReturnValue");
            if (attrNulReturnValue != null) {
                nullReturnValue = attrNulReturnValue;
            }
            if (nullReturnValue == null) {
                out.write("            return(null);\n");
            } else {
                out.write("            return(" + nullReturnValue + ");\n");
            }
            out.write("\n");
            out.write("        return(attr.getSV());\n");
            out.write("    }\n\n");
            String preserveNewlines = attributeDef.getSV("preserveNewlines");
            if (preserveNewlines != null) {
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + typeName + " get" + functionName + "WithNewlines(){\n");
                out.write("        " + attrType + " attr = (" + attrType + ") get(MetaDMSAG.__" + attrname + ");\n");
                out.write("        if (attr == null)\n");
                if (attrNulReturnValue != null) {
                    nullReturnValue = attrNulReturnValue;
                }
                if (nullReturnValue == null) {
                    out.write("            return(null);\n");
                } else {
                    out.write("            return(" + nullReturnValue + ");\n");
                }
                out.write("\n");
                out.write("        return(attr.getSV().replaceAll(\"\\\\\\\\n\",\"\\\\\\n\"));\n");
                out.write("    }\n\n");
            }
        } else {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (isObjREF) {
                out.write("    public " + typeName + " get" + functionName + "(){\n");
                out.write("        " + attrType + " attr = (" + attrType + ") mycore.get(MetaDMSAG.__" + attrname + ");\n");
                out.write("        if (attr == null)\n");
                out.write("            return(null);\n");
                out.write("        " + typeName + "DMO obj = attr.getSV().getObject();\n");
                out.write("        return((" + typeName + ")obj.getContainer());\n");
                out.write("    }\n\n");
            } else {
                out.write("    public " + typeName + " get" + functionName + "(){\n");
                out.write("        return(mycore.get" + functionName + "());\n");
                out.write("    }\n\n");
                String preserveNewlines = attributeDef.getSV("preserveNewlines");
                if (preserveNewlines != null) {
                    out.write("    public " + typeName + " get" + functionName + "WithNewlines(){\n");
                    out.write("        return(mycore.get" + functionName + "WithNewlines());\n");
                    out.write("    }\n\n");
                }
            }
        }
        if (DMO) {
            out.write("    /**\n");
            out.write("     * Sets " + attrname + " to the specified value.\n");
            out.write("     * @param value A value compatible with " + attrType + "\n");
            out.write("     * @throws DmcValueException if the value is incorrect\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
            out.write("        DmcAttribute<?> attr = get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            attr = new " + attrType + "(MetaDMSAG.__" + attrname + ");\n");
            out.write("        \n");
            out.write("        attr.set(value);\n");
            out.write("        set(MetaDMSAG.__" + attrname + ",attr);\n");
            out.write("    }\n\n");
        } else if (isObjREF) {
            out.write("    /**\n");
            out.write("     * Sets " + attrname + " to the specified value.\n");
            out.write("     * @param value A value compatible with " + typeName + "\n");
            out.write("     * @throws DmcValueException if the value is incorrect\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void set" + functionName + "(" + typeName + " value) throws DmcValueException {\n");
            out.write("        mycore.set" + functionName + "(value.getDmcObject());\n");
            out.write("    }\n\n");
        } else {
            out.write("    /**\n");
            out.write("     * Sets " + attrname + " to the specified value.\n");
            out.write("     * @param value A value compatible with " + attrType + "\n");
            out.write("     * @throws DmcValueException if the value is incorrect\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
            out.write("        mycore.set" + functionName + "(value);\n");
            out.write("    }\n\n");
        }
    }

    void dumpMVAccessFunction(BufferedWriter out, String attrname, boolean DMO, String dmoClass) throws IOException, ResultException {
        DmcUncheckedObject attributeDef = this.attributeDefs.get(attrname);
        String typeName = attributeDef.getSV("type");
        boolean isObjREF = false;
        if (typeName == null) {
            ResultException ex = new ResultException();
            ex.addError("No type specified for attribute: " + attrname);
            ex.result.lastResult().lineNumber(attributeDef.lineNumber);
            throw ex;
        }
        DmcUncheckedObject typeDef = this.typeDefs.get(typeName);
        if (typeDef == null) {
            typeDef = this.enumDefs.get(typeName);
        }
        if (typeDef == null && (typeDef = this.classDefs.get(typeName)) != null) {
            isObjREF = true;
        }
        boolean isComplexType = false;
        if (this.complexTypeDefs.get(typeName) != null) {
            isComplexType = true;
        }
        if (typeDef == null) {
            ResultException ex = new ResultException();
            ex.addError("Unknown type: " + typeName + " for attribute: " + attrname);
            ex.result.lastResult().lineNumber(attributeDef.lineNumber);
            throw ex;
        }
        String attrType = "DmcType" + typeName;
        if (isObjREF) {
            attrType = attrType + "REF";
        }
        attrType = attrType + "MV";
        StringBuffer functionName = new StringBuffer();
        functionName.append(attrname);
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        if (DMO) {
            if (isObjREF) {
                out.write("     * @return An Iterator of " + typeName + "DMO objects.\n");
                out.write("     */\n");
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public Iterator<" + typeName + "REF> get" + functionName + "(){\n");
            } else {
                out.write("     * @return An Iterator of " + typeName + " objects.\n");
                out.write("     */\n");
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
            }
            out.write("        " + attrType + " attr = (" + attrType + ") get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            return(null);\n");
            out.write("\n");
            out.write("        return(attr.getMV());\n");
            out.write("    }\n\n");
            String preserveNewlines = attributeDef.getSV("preserveNewlines");
            if (preserveNewlines != null && !isComplexType) {
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public Iterator<" + typeName + "> get" + functionName + "WithNewlines(){\n");
                out.write("        " + attrType + " attr = (" + attrType + ") get(MetaDMSAG.__" + attrname + ");\n");
                out.write("        if (attr == null)\n");
                out.write("            return(null);\n");
                out.write("\n");
                out.write("        " + attrType + " withNewLines = new " + attrType + "();\n");
                out.write("        Iterator<" + typeName + "> it = attr.getMV();\n");
                out.write("        while(it.hasNext()){\n");
                out.write("            try{\n");
                out.write("                withNewLines.add(it.next().replaceAll(\"\\\\\\\\n\",\"\\\\\\n\"));\n");
                out.write("            } catch (DmcValueException e) {\n");
                out.write("                e.printStackTrace();\n");
                out.write("            }\n");
                out.write("        }\n");
                out.write("\n");
                out.write("        return(withNewLines.getMV());\n");
                out.write("    }\n\n");
            }
        } else if (isObjREF) {
            out.write("     * @return An Iterator of " + typeName + " objects.\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public " + typeName + "IterableDMW get" + functionName + "(){\n");
            out.write("        " + attrType + " attr = (" + attrType + ") mycore.get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            return(" + typeName + "IterableDMW.emptyList);\n");
            out.write("\n");
            out.write("        return(new " + typeName + "IterableDMW(attr.getMV()));\n");
            out.write("    }\n\n");
        } else {
            out.write("     * @return An Iterator of " + typeName + " objects.\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
            out.write("        " + attrType + " attr = (" + attrType + ") mycore.get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            return(null);\n");
            out.write("\n");
            out.write("        return(attr.getMV());\n");
            out.write("    }\n\n");
            String preserveNewlines = attributeDef.getSV("preserveNewlines");
            if (preserveNewlines != null && !isComplexType) {
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public Iterator<" + typeName + "> get" + functionName + "WithNewlines(){\n");
                out.write("        " + attrType + " attr = (" + attrType + ") mycore.get(MetaDMSAG.__" + attrname + ");\n");
                out.write("        if (attr == null)\n");
                out.write("            return(null);\n");
                out.write("\n");
                out.write("        " + attrType + " withNewLines = new " + attrType + "();\n");
                out.write("        Iterator<" + typeName + "> it = attr.getMV();\n");
                out.write("        while(it.hasNext()){\n");
                out.write("            try{\n");
                out.write("                withNewLines.add(it.next().replaceAll(\"\\\\\\\\n\",\"\\\\\\n\"));\n");
                out.write("            } catch (DmcValueException e) {\n");
                out.write("                e.printStackTrace();\n");
                out.write("            }\n");
                out.write("        }\n");
                out.write("\n");
                out.write("        return(withNewLines.getMV());\n");
                out.write("    }\n\n");
            }
        }
        if (DMO) {
            out.write("    /**\n");
            out.write("     * Adds another " + attrname + " value.\n");
            out.write("     * @param value A value compatible with " + attrType + "\n");
            out.write("     * @return the attribute instance\n");
            out.write("     * @throws DmcValueException if the value is incorrect\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public DmcAttribute<?> add" + functionName + "(Object value) throws DmcValueException {\n");
            out.write("        DmcAttribute<?> attr = get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            attr = new " + attrType + "(MetaDMSAG.__" + attrname + ");\n");
            out.write("        \n");
            out.write("        attr.add(value);\n");
            out.write("        add(MetaDMSAG.__" + attrname + ",attr);\n");
            out.write("        return(attr);\n");
            out.write("    }\n\n");
        } else {
            if (isObjREF) {
                out.write("    /**\n");
                out.write("     * Adds another " + attrname + " value.\n");
                out.write("     * @param value A value compatible with " + typeName + "\n");
                out.write("     * @return the attribute instance\n");
                out.write("     * @throws DmcValueException if the value is incorrect\n");
                out.write("     */\n");
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public DmcAttribute<?> add" + functionName + "(" + typeName + " value) throws DmcValueException {\n");
                out.write("        DmcAttribute<?> attr = mycore.add" + functionName + "(value.getDmcObject());\n");
                out.write("        return(attr);\n");
                out.write("    }\n\n");
            } else {
                out.write("    /**\n");
                out.write("     * Adds another " + attrname + " value.\n");
                out.write("     * @param value A value compatible with " + attrType + "\n");
                out.write("     * @throws DmcValueException if the value is incorrect\n");
                out.write("     */\n");
                out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public void add" + functionName + "(Object value) throws DmcValueException {\n");
                out.write("        mycore.add" + functionName + "(value);\n");
                out.write("    }\n\n");
            }
            out.write("    /**\n");
            out.write("     * @return the number of " + attrname + " values.\n");
            out.write("     */\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public int get" + functionName + "Size(){\n");
            out.write("        DmcAttribute<?> attr = mycore.get(MetaDMSAG.__" + attrname + ");\n");
            out.write("        if (attr == null)\n");
            out.write("            return(0);\n");
            out.write("        return(attr.getMVSize());\n");
            out.write("    }\n\n");
        }
    }

    private void dumpDmcTypes(String od) throws IOException, ResultException {
        String cn;
        DmcUncheckedObject go;
        int i;
        for (i = 0; i < this.origOrderClasses.size(); ++i) {
            go = this.classDefs.get(this.origOrderClasses.get(i));
            cn = go.getSV("name");
            if (cn == null) {
                System.out.println("Couldn't get name for class definition:\n" + go);
                continue;
            }
            if (go.getSV("isNamedBy") == null) continue;
            ManagedFileWriter out = null;
            out = FileUpdateManager.instance().getWriter(od, "DmcType" + cn + "REF.java");
            out.write(this.LGPL.toString());
            out.write("package org.dmd.dms.generated.types;\n\n");
            out.write("import java.io.Serializable;\n");
            out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
            out.write("import org.dmd.dmc.DmcValueException;\n");
            out.write("import org.dmd.dmc.DmcObjectName;\n");
            out.write("import org.dmd.dmc.DmcOutputStreamIF;\n");
            out.write("import org.dmd.dmc.DmcInputStreamIF;\n");
            out.write("import org.dmd.dmc.types.DmcTypeNamedObjectREF;\n");
            out.write("import org.dmd.dms.generated.dmo.*;\n");
            out.write("import org.dmd.dmc.types.DefinitionName;\n");
            out.write("/**\n * The DmcType" + cn + "REF class.\n");
            out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
            out.write(" * manually.\n");
            out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write(" */\n");
            out.write("@SuppressWarnings(\"serial\")\n");
            out.write("abstract public class DmcType" + cn + "REF extends DmcTypeNamedObjectREF<" + cn + "REF, DefinitionName> implements Serializable {\n\n");
            out.write("    /**\n");
            out.write("     * Default constructor.\n");
            out.write("     */\n");
            out.write("    public DmcType" + cn + "REF(){\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Default constructor.\n");
            out.write("     */\n");
            out.write("    public DmcType" + cn + "REF(DmcAttributeInfo ai){\n");
            out.write("        super(ai);\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Checks that we have a " + cn + "REF or " + cn + "DMO.\n");
            out.write("     */\n");
            out.write("    public " + cn + "REF typeCheck(Object value) throws DmcValueException {\n");
            out.write("        " + cn + "REF rc = null;\n");
            out.write("        if (value instanceof " + cn + "REF)\n");
            out.write("            rc = (" + cn + "REF)value;\n");
            out.write("        else if (value instanceof " + cn + "DMO)\n");
            out.write("            rc = new " + cn + "REF((" + cn + "DMO)value);\n");
            out.write("        else if (value instanceof DmcObjectName){\n");
            out.write("            rc = new " + cn + "REF();\n");
            out.write("            rc.setName((DmcObjectName)value);\n");
            out.write("        }\n");
            out.write("        else if (value instanceof String){\n");
            out.write("            rc = new " + cn + "REF();\n");
            out.write("            rc.setName(new DefinitionName((String)value));\n");
            out.write("        }\n");
            out.write("        else\n");
            out.write("            throw(new DmcValueException(\"Object of class:\" + value.getClass().getName() + \" passed where a " + cn + "REF/DMO or DmcObjectName expected.\"));\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    protected " + cn + "REF getNewHelper(){\n");
            out.write("        return( new " + cn + "REF());\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    protected DefinitionName getNewName(){\n");
            out.write("        return( new DefinitionName());\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    protected String getDMOClassName(){\n");
            out.write("        return( " + cn + "DMO.class.getName());\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    protected boolean isDMO(Object value){\n");
            out.write("        if (value instanceof " + cn + "DMO)\n");
            out.write("            return(true);\n");
            out.write("        return(false);\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Returns a clone of a value associated with this type.\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public " + cn + "REF cloneValue(" + cn + "REF val){\n");
            out.write("        " + cn + "REF rc = new " + cn + "REF(val);\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public void serializeValue(DmcOutputStreamIF dos, " + cn + "REF value) throws Exception {\n");
            out.write("        value.serializeIt(dos);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public " + cn + "REF deserializeValue(DmcInputStreamIF dis) throws Exception {\n");
            out.write("        " + cn + "REF rc = new " + cn + "REF();\n");
            out.write("        rc.deserializeIt(dis);\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("}\n");
            ((BufferedWriter)out).close();
            String nameType = "DefinitionName";
            if (cn.equals("RuleData")) {
                nameType = "RuleName";
            }
            out = FileUpdateManager.instance().getWriter(od, cn + "REF.java");
            out.write(this.LGPL.toString());
            out.write("package org.dmd.dms.generated.types;\n\n");
            out.write("import java.io.Serializable;\n");
            out.write("import org.dmd.dmc.DmcAttribute;\n");
            out.write("import org.dmd.dmc.DmcValueException;\n");
            out.write("import org.dmd.dmc.DmcObjectName;\n");
            out.write("import org.dmd.dmc.DmcOutputStreamIF;\n");
            out.write("import org.dmd.dmc.DmcInputStreamIF;\n");
            out.write("import org.dmd.dmc.DmcNamedObjectNontransportableREF;\n");
            out.write("import org.dmd.dmc.types.DmcType" + nameType + ";\n");
            out.write("import org.dmd.dms.generated.dmo.*;\n");
            if (cn.equals("ClassDefinition")) {
                out.write("import org.dmd.dmc.DmcOmni;\n");
                out.write("import org.dmd.dmc.DmcClassInfo;\n");
            }
            out.write("/**\n * The " + cn + "REF class.\n");
            out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
            out.write(" * manually.\n");
            out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write(" */\n");
            out.write("@SuppressWarnings(\"serial\")\n");
            out.write("public class " + cn + "REF extends DmcNamedObjectNontransportableREF<" + cn + "DMO> implements Serializable {\n\n");
            if (cn.equals("ClassDefinition")) {
                out.write("    transient DmcClassInfo info;\n\n");
            }
            out.write("    DmcType" + nameType + " myName;\n\n");
            out.write("    /**\n");
            out.write("     * Default constructor.\n");
            out.write("     */\n");
            out.write("    public " + cn + "REF(){\n");
            out.write("        myName = null;\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Copy constructor.\n");
            out.write("     */\n");
            out.write("    public " + cn + "REF(" + cn + "REF original){\n");
            out.write("        myName = original.myName;\n");
            out.write("        object = original.object;\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Wrapper constructor.\n");
            out.write("     */\n");
            out.write("    public " + cn + "REF(" + cn + "DMO dmo){\n");
            out.write("        myName = (DmcType" + nameType + ") dmo.getObjectNameAttribute();\n");
            out.write("        object = dmo;\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Sets our object.\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public void setObject(" + cn + "DMO o){\n");
            out.write("        object = o;\n");
            out.write("    }\n\n");
            out.write("    /**\n");
            out.write("     * Clones this reference.\n");
            out.write("     */\n");
            out.write("    public " + cn + "REF cloneMe(){\n");
            out.write("        " + cn + "REF rc = new " + cn + "REF();\n");
            out.write("        rc.myName = myName;\n");
            out.write("        rc.object = object;\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public void setName(DmcObjectName n) throws DmcValueException {\n");
            out.write("        if (myName == null);\n");
            out.write("            myName = new  DmcType" + nameType + "SV(MetaDMSAG.__name);\n");
            out.write("        myName.set(n);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public DmcAttribute<?> getObjectNameAttribute(){\n");
            out.write("         return(myName);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public DmcObjectName getObjectName(){\n");
            out.write("         return(myName.getSV());\n");
            out.write("    }\n\n");
            out.write("    public void serializeIt(DmcOutputStreamIF dos) throws Exception {\n");
            out.write("         myName.serializeIt(dos);\n");
            out.write("         // the object goes nowhere\n");
            out.write("    }\n\n");
            out.write("    public void deserializeIt(DmcInputStreamIF dis) throws Exception {\n");
            out.write("        myName = (DmcType" + nameType + ") dis.getAttributeInstance();\n");
            out.write("        myName.deserializeIt(dis);\n");
            out.write("    }\n\n");
            if (cn.equals("ClassDefinition")) {
                out.write("    public DmcClassInfo getClassInfo() {\n");
                out.write("        if (info == null){\n");
                out.write("            if (myName == null)\n");
                out.write("                throw(new IllegalStateException(\"No name set for a ClassDefinitionREF\"));\n");
                out.write("            info = DmcOmni.instance().getClassInfo(myName.getSV().getNameString());\n");
                out.write("            if (info == null)\n");
                out.write("                throw(new IllegalStateException(\"Unable to retrive class info for class: \" + myName.getSV().getNameString() + \" ensure that you have loaded the DmcOmni with the appropriate schemas.\"));\n");
                out.write("        }\n");
                out.write("        return(info);\n");
                out.write("    }\n\n");
            }
            out.write("}\n");
            ((BufferedWriter)out).close();
        }
        for (i = 0; i < this.origOrderEnums.size(); ++i) {
            go = this.enumDefs.get(this.origOrderEnums.get(i));
            cn = go.getSV("name");
            if (cn == null) {
                System.out.println("Couldn't get name for enum definition:\n" + go);
                continue;
            }
            this.dumpDmcType(od, cn, true);
        }
    }

    void dumpDmcType(String od, String cn, boolean supportsString) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, "DmcType" + cn + ".java");
        out.write(this.LGPL.toString());
        out.write("package org.dmd.dms.generated.types;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import org.dmd.dmc.DmcInputStreamIF;\n");
        out.write("import org.dmd.dmc.DmcOutputStreamIF;\n");
        out.write("import org.dmd.dmc.DmcAttribute;\n");
        out.write("import org.dmd.dmc.DmcAttributeInfo;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        if (supportsString) {
            out.write("import org.dmd.dms.generated.enums.*;\n\n");
        } else {
            out.write("import org.dmd.dms.*;\n\n");
        }
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The DmcType" + cn + " class.\n");
        out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
        out.write(" * manually.\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("abstract public class DmcType" + cn + " extends DmcAttribute<" + cn + "> implements Serializable {\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public DmcType" + cn + "(DmcAttributeInfo ai){\n");
        out.write("        super(ai);\n");
        out.write("    }\n\n");
        out.write("    protected " + cn + " typeCheck(Object value) throws DmcValueException {\n");
        out.write("        " + cn + " rc = null;\n\n");
        out.write("        if (value instanceof " + cn + "){\n");
        out.write("            rc = (" + cn + ")value;\n");
        out.write("        }\n");
        if (supportsString) {
            out.write("        else if (value instanceof String){\n");
            out.write("            rc = " + cn + ".get((String)value);\n");
            out.write("            if (rc == null){\n");
            out.write("                throw(new DmcValueException(\"Value: \" + value.toString() + \" is not a valid " + cn + " value.\"));\n");
            out.write("            }\n");
            out.write("        }\n");
            out.write("        else if (value instanceof Integer){\n");
            out.write("            rc = " + cn + ".get((Integer)value);\n");
            out.write("            if (rc == null){\n");
            out.write("                throw(new DmcValueException(\"Value: \" + value.toString() + \" is not a valid " + cn + " value.\"));\n");
            out.write("            }\n");
            out.write("        }\n");
        }
        out.write("        else{\n");
        out.write("            throw(new DmcValueException(\"Object of class: \" + value.getClass().getName() + \" passed where object compatible with " + cn + " expected.\"));\n");
        out.write("        }\n");
        out.write("        return(rc);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    /**\n");
        out.write("     * Returns a clone of a value associated with this type.\n");
        out.write("     */\n");
        out.write("    public " + cn + " cloneValue(" + cn + " val){\n");
        out.write("        " + cn + " rc = val;\n");
        out.write("        return(rc);\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Writes a " + cn + ".\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public void serializeValue(DmcOutputStreamIF dos, " + cn + " value) throws Exception {\n");
        out.write("        dos.writeShort(value.intValue());\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Reads a " + cn + ".\n");
        out.write("     */\n");
        out.write("    @Override\n");
        out.write("    public " + cn + " deserializeValue(DmcInputStreamIF dis) throws Exception {\n");
        out.write("        return(" + cn + ".get(dis.readShort()));\n");
        out.write("    }\n\n");
        out.write("\n");
        out.write("\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
    }

    /*
     * WARNING - void declaration
     */
    void dumpComplexType(String od, DmcUncheckedObject ct) throws IOException, ResultException, DmcValueException {
        if (ct.get("field") == null) {
            MetaComplexTypeFormatter.dumpComplexType(od, ct, this);
            return;
        }
        String ctn = ct.getSV("name");
        String fieldSeparator = ct.getSV("fieldSeparator");
        boolean whiteSpaceSeparator = false;
        if (fieldSeparator == null) {
            whiteSpaceSeparator = true;
            fieldSeparator = " ";
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(od, ctn + ".java");
        DebugInfo.debug("Generating: " + od + File.separator + ctn + ".java");
        ArrayList<Field> fields = this.getComplexTypeFields(ct);
        boolean hasRefs = false;
        ArrayList<String> refFields = new ArrayList<String>();
        for (Field field : fields) {
            String isRefType;
            DmcUncheckedObject type = this.typeDefs.get(field.type);
            if (type == null && (type = this.enumDefs.get(field.type)) == null) {
                DebugInfo.debug("Unknown type in ComplexTypeDefinition: " + field.type);
                System.exit(1);
            }
            if ((isRefType = type.getSV("isRefType")) == null) continue;
            hasRefs = true;
            refFields.add(field.name);
        }
        out.write(this.LGPL.toString());
        out.write("package org.dmd.dms.generated.types;\n\n");
        ImportManager imports = new ImportManager();
        imports.addImport("java.io.Serializable", "Marker interface for serialization");
        imports.addImport("org.dmd.dmc.DmcInputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dmc.DmcOutputStreamIF", "To support serialization");
        imports.addImport("org.dmd.dmc.types.IntegerVar", "For getNextField()");
        imports.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dms.generated.enums.ValueTypeEnum", "For fake DmcAttributeInfo");
        imports.addImport("org.dmd.dmc.DmcAttributeInfo", "For fake DmcAttributeInfo");
        if (hasRefs) {
            imports.addImport("org.dmd.dmc.DmcNameResolverWithClashSupportIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameClashResolverIF", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcNameResolverIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcNamedObjectIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcNamedObjectREF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcContainerIF", "Reference resolution");
            imports.addImport("org.dmd.dmc.DmcObject", "Ambiguous reference resolution");
            imports.addImport("org.dmd.dmc.DmcValueExceptionSet", "Ambiguous reference resolution");
        }
        imports.addImport("org.dmd.dmc.DmcValueException", "For type checking");
        this.getComplexTypeImports(imports, fields);
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("/**\n * The " + ctn + " class.\n");
        out.write(" * This code was auto-generated by the createmeta utility and shouldn't be alterred\n");
        out.write(" * manually.\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + ctn + " implements Serializable {\n\n");
        out.write(this.getComplexTypeFieldInstances(fields));
        out.write("    /**\n");
        out.write("     * Default constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(){\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Copy constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(" + ctn + " original){\n");
        for (Field field : fields) {
            out.write("        " + field.name + " = original." + field.name + ";\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * All fields constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(");
        boolean bl = true;
        for (Field field : fields) {
            void var11_14;
            out.write(field.type + " f" + (int)var11_14);
            if (++var11_14 > fields.size()) continue;
            out.write(", ");
        }
        out.write(") throws DmcValueException {\n");
        boolean bl2 = true;
        for (Field field : fields) {
            void var11_16;
            out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(f" + (int)var11_16 + ");\n");
            ++var11_16;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String based constructor.\n");
        out.write("     */\n");
        out.write("    public " + ctn + "(String initialInput) throws DmcValueException {\n");
        out.write("        IntegerVar seppos = new IntegerVar(-1);\n");
        if (whiteSpaceSeparator) {
            out.write("        String input = initialInput.trim();\n");
            out.write("        input = input.replaceAll(\"(\\\\s)+\", \" \");\n");
        } else {
            out.write("        String input = initialInput.trim();\n");
        }
        boolean bl3 = true;
        for (Field field : fields) {
            void var11_18;
            if (var11_18 == fields.size()) {
                out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(getNextField(input,seppos,\"" + field.name + "\",true));\n");
            } else {
                out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.typeCheck(getNextField(input,seppos,\"" + field.name + "\",false));\n");
            }
            ++var11_18;
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Serialization.\n");
        out.write("     */\n");
        out.write("    public void serializeIt(DmcOutputStreamIF dos) throws Exception {\n");
        for (Field field : fields) {
            out.write("        DmcType" + field.type + "STATIC.instance.serializeValue(dos, " + field.name + ");\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Deserialization.\n");
        out.write("     */\n");
        out.write("    public void deserializeIt(DmcInputStreamIF dis) throws Exception {\n");
        for (Field field : fields) {
            out.write("        " + field.name + " = DmcType" + field.type + "STATIC.instance.deserializeValue(dis);\n");
        }
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * String form.\n");
        out.write("     */\n");
        out.write("    public String toString(){\n");
        boolean bl4 = true;
        out.write("        return(");
        for (Field field : fields) {
            void var11_20;
            out.write(field.name + ".toString()");
            if (var11_20 < fields.size()) {
                out.write(" + \"" + fieldSeparator + "\" + ");
            }
            ++var11_20;
        }
        out.write(");\n");
        out.write("    }\n\n");
        for (Field field : fields) {
            out.write("    public " + field.type + " get" + Manipulator.capFirstChar(field.name) + "(){\n");
            out.write("        return(" + field.name + ");\n");
            out.write("    }\n\n");
        }
        if (hasRefs) {
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (String fn : refFields) {
                out.write("        if (!" + fn + ".isResolved()){\n");
                out.write("            obj = resolver.findNamedObject(" + fn + ".getObjectName());\n");
                out.write("            if (obj == null)\n");
                out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + fn + ".getObjectName() + \" via attribute: \" + attrName));\n");
                out.write("        \n");
                out.write("            if (obj instanceof DmcContainerIF)\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                out.write("            else\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject(obj);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n");
            out.write("    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {\n");
            out.write("        DmcNamedObjectIF  obj = null;\n\n");
            for (String fn : refFields) {
                out.write("        if (!" + fn + ".isResolved()){\n");
                out.write("            obj = resolver.findNamedObjectMayClash(object, " + fn + ".getObjectName(), ncr, " + fn + "AI);\n");
                out.write("            if (obj == null)\n");
                out.write("                throw(new DmcValueException(\"Could not resolve reference to: \" + " + fn + ".getObjectName() + \" via attribute: \" + ai.name));\n");
                out.write("        \n");
                out.write("            if (obj instanceof DmcContainerIF)\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());\n");
                out.write("            else\n");
                out.write("                ((DmcNamedObjectREF)" + fn + ").setObject(obj);\n");
                out.write("        }\n");
                out.write("        \n");
            }
            out.write("    }\n\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public void removeBackRefsFromValue(){\n");
            for (String fn : refFields) {
                out.write("        if (" + fn + " != null){\n");
                out.write("            " + fn + ".removeBackref();\n");
                out.write("        }\n");
            }
            out.write("    }\n\n");
        }
        if (whiteSpaceSeparator) {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    String getNextField(String input, IntegerVar seppos, String fn, boolean last) throws DmcValueException {\n");
            out.write("    \t   String rc = null;\n");
            out.write("    \t   int start = seppos.intValue();\n");
            out.write("\n");
            out.write("    \t   if ( (start+1) >= input.length())\n");
            out.write("    \t\t   throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: " + ctn + "\"));\n");
            out.write("\n");
            out.write("    \t   if (last){\n");
            out.write("    \t       rc = input.substring(start+1);\n");
            out.write("    \t   }\n");
            out.write("    \t   else{\n");
            out.write("    \t       int pos = -1;\n");
            out.write("    \t       if (start > 0)\n");
            out.write("    \t\t       pos = input.indexOf(\"" + fieldSeparator + "\", start+1);\n");
            out.write("    \t       else\n");
            out.write("    \t\t       pos = input.indexOf(\"" + fieldSeparator + "\");\n");
            out.write("\n");
            out.write("    \t       if (pos == -1)\n");
            out.write("    \t\t       throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: " + ctn + "\"));\n");
            out.write("\n");
            out.write("    \t\t   while(pos < (input.length()-1)){\n");
            out.write("    \t\t       if ( input.charAt(pos+1) == '" + fieldSeparator + "')\n");
            out.write("    \t\t           pos++;\n");
            out.write("    \t\t       else\n");
            out.write("    \t\t           break;\n");
            out.write("    \t\t   }\n");
            out.write("\n");
            out.write("    \t       rc = input.substring(start+1, pos).trim();\n");
            out.write("\n");
            out.write("    \t       seppos.set(pos);\n");
            out.write("        }\n");
            out.write("\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
        } else {
            out.write("    String getNextField(String input, IntegerVar seppos, String fn, boolean last) throws DmcValueException {\n");
            out.write("    \t   String rc = null;\n");
            out.write("    \t   int start = seppos.intValue();\n");
            out.write("   \t   \n");
            out.write("    \t   if (last){\n");
            out.write("            if ( (start+1) >= input.length())\n");
            out.write("                rc = \"\";\n");
            out.write("            else\n");
            out.write("                rc = input.substring(start+1);\n");
            out.write("        }\n");
            out.write("\t       else{\n");
            out.write("    \t       if ( (start+1) >= input.length())\n");
            out.write("        \t\t   throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: RuleParam\"));\n");
            out.write("   \t\t   \n");
            out.write("        \t   int pos = -1;\n");
            out.write("\t           if (start > -1){\n");
            out.write("\t        \t   start = start + 1;\n");
            out.write("\t    \t       pos = input.indexOf(\"" + fieldSeparator + "\", start);\n");
            out.write("\t           }\n");
            out.write("\t           else{\n");
            out.write("\t        \t   start = 0;\n");
            out.write("\t    \t       pos = input.indexOf(\"" + fieldSeparator + "\");\n");
            out.write("\t           }\n");
            out.write("\t       \n");
            out.write("\t           if (pos == start){\n");
            out.write("\t        \t   seppos.set(pos);\n");
            out.write("\t        \t   return(\"\");\n");
            out.write("\t           }\n");
            out.write("\t       \n");
            out.write("\t           if (pos == -1)\n");
            out.write("\t\t           throw (new DmcValueException(\"Missing value for field: \" + fn + \" in complex type: RuleParam\"));\n");
            out.write("\t\t       \n");
            out.write("\t           rc = input.substring(start, pos).trim();\n");
            out.write("\t       \n");
            out.write("\t           seppos.set(pos);\n");
            out.write("        }\n");
            out.write("    \n");
            out.write("        return(rc);\n");
            out.write("    }\n");
            out.write("\n");
        }
        out.write("    public void toJSON(StringBuffer sb, int padding, String indent) {\n");
        out.write("        throw(new IllegalStateException(\"This needs to be implemented\"));\n");
        out.write("    }\n\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
        GenUtility.dumpComplexTypeDmcType(this.LGPL.toString(), "org.dmd.dms", od, ctn, hasRefs);
    }

    void getComplexTypeImports(ImportManager imports, ArrayList<Field> fields) throws ResultException {
        for (Field field : fields) {
            DmcUncheckedObject typeDef = this.typeDefs.get(field.type);
            if (typeDef != null) continue;
            typeDef = this.enumDefs.get(field.type);
            if (typeDef != null) {
                String imp = "org.dmd.dms.generated.enums." + field.type;
                imports.addImport(imp, "Type for field: " + field.name);
                continue;
            }
            typeDef = this.typeDefs.get(field.type + "REF");
            String primitiveType = typeDef.getSV("primitiveType");
            if (primitiveType == null) continue;
            imports.addImport(primitiveType, "Type for field: " + field.name);
        }
    }

    String getComplexTypeFieldInstances(ArrayList<Field> fields) {
        StringBuffer sb = new StringBuffer();
        for (Field field : fields) {
            sb.append("    // " + field.descr + "\n");
            sb.append("    " + field.type + " " + field.name + ";\n");
            String type = field.type;
            type = type.replaceAll("REF", "");
            sb.append("    final static DmcAttributeInfo " + field.name + "AI = new DmcAttributeInfo(\"" + field.name + "\",0,\"" + type + "\",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);\n\n");
        }
        return sb.toString();
    }

    ArrayList<Field> getComplexTypeFields(DmcUncheckedObject ct) {
        ArrayList<Field> rc = new ArrayList<Field>();
        NamedStringArray fields = ct.get("field");
        for (String field : fields) {
            field = field.trim();
            field = field.replaceAll("(\\s)+", " ");
            int c1pos = field.indexOf(" ");
            int c2pos = field.indexOf(" ", c1pos + 1);
            String type = field.substring(0, c1pos).trim();
            String name = field.substring(c1pos + 1, c2pos).trim();
            String descr = field.substring(c2pos + 1).trim();
            DmcUncheckedObject typeDef = this.typeDefs.get(type);
            if (typeDef == null && this.enumDefs.get(type) == null) {
                type = type + "REF";
            }
            rc.add(new Field(type, name, descr));
        }
        return rc;
    }

    boolean hasAnyEnumAttributes(DmcUncheckedObject classdef) throws ResultException {
        boolean rc = false;
        NamedStringArray must = classdef.get("must");
        NamedStringArray may = classdef.get("may");
        ArrayList<String> atlist = new ArrayList<String>();
        if (must != null) {
            for (String attrName : must) {
                atlist.add(attrName);
            }
        }
        if (may != null) {
            for (String attrName : may) {
                atlist.add(attrName);
            }
        }
        for (String attrname : atlist) {
            DmcUncheckedObject attrdef = this.attributeDefs.get(attrname);
            if (attrdef == null) {
                ResultException ex = new ResultException();
                ex.addError("Unknown attribute: " + attrname);
                throw ex;
            }
            if (!this.isEnumAttribute(attrdef)) continue;
            rc = true;
            break;
        }
        return rc;
    }

    boolean isEnumAttribute(DmcUncheckedObject uco) throws ResultException {
        String typeName = uco.getSV("type");
        return this.enumDefs.get(typeName) != null;
    }

    class Field {
        String type;
        String name;
        String descr;

        Field(String t, String n, String d) {
            this.type = t;
            this.name = n;
            this.descr = d;
        }
    }
}

