/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.tools.dmogenerator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.doc.web.DmsHtmlDocGenerator;
import org.dmd.dms.util.DmoGenerator;
import org.dmd.dms.util.DmsSchemaParser;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.UtilityOptions;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.Classifier;
import org.dmd.util.parsing.CommandLine;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.StringArrayList;
import org.dmd.util.parsing.TokenArrayList;

public class DmoGenUtility {
    SchemaManager dmsSchema;
    SchemaManager readSchemas;
    ConfigFinder finder;
    DmsSchemaParser parser;
    DmoGenerator codeGenerator;
    DmsHtmlDocGenerator docGenerator;
    PrintfFormat format;
    Classifier classifier;
    CommandLine cl;
    StringBuffer help;
    BooleanVar helpFlag = new BooleanVar();
    StringArrayList srcdir = new StringArrayList();
    StringBuffer workspace = new StringBuffer();
    BooleanVar autogen = new BooleanVar();
    StringBuffer cfg = new StringBuffer();
    BooleanVar debug = new BooleanVar();
    StringBuffer docdir = new StringBuffer();
    StringArrayList jars = new StringArrayList();
    BooleanVar checkRules = new BooleanVar();
    BooleanVar checkOnly = new BooleanVar();
    StringArrayList targets = new StringArrayList();
    BooleanVar qwarnings = new BooleanVar();
    BooleanVar qprogress = new BooleanVar();

    public DmoGenUtility(String[] args) throws ResultException, IOException, DmcValueException, DmcValueExceptionSet, DmcNameClashException {
        this.initHelp();
        this.cl = new CommandLine();
        this.cl.addOption("-h", this.helpFlag, "Dumps the help message.");
        this.cl.addOption("-srcdir", this.srcdir, "The source directories to search.");
        this.cl.addOption("-workspace", this.workspace, "The workspace prefix");
        this.cl.addOption("-autogen", this.autogen, "Indicates that you want to generate from all configs automatically.");
        this.cl.addOption("-cfg", this.cfg, "The configuration file to load.");
        this.cl.addOption("-docdir", this.docdir, "The documentation directory.");
        this.cl.addOption("-debug", this.debug, "Dump debug information.");
        this.cl.addOption("-jars", this.jars, "The prefixs of jars to search for .dms config files.");
        this.cl.addOption("-checkRules", this.checkRules, "Indicates if you want to dynamically instantiate and validate rule definitions.");
        this.cl.addOption("-checkOnly", this.checkOnly, "Indicates if you want to only check rule definitions, not generate code.");
        this.cl.addOption("-targets", this.targets, "Indicates you only want to generate for the specified configs");
        this.cl.addOption("-qwarnings", this.qwarnings, "Indicates that we don't want to see warning messages");
        this.cl.addOption("-qprogress", this.qprogress, "Indicates that we don't want to see progress messages");
        this.cl.parseArgs(args);
        if (this.qwarnings.booleanValue()) {
            UtilityOptions.instance().quiteWarnings(this.qwarnings.booleanValue());
        }
        if (this.qprogress.booleanValue()) {
            UtilityOptions.instance().quiteProgress(this.qprogress.booleanValue());
        }
        if (!UtilityOptions.instance().quietProgress()) {
            System.out.print("TARGETS(" + this.targets.size() + "): ");
            for (int i = 0; i < this.targets.size(); ++i) {
                System.out.print((String)this.targets.get(i) + " ");
            }
            System.out.println();
        }
        this.dmsSchema = new SchemaManager();
        if (this.helpFlag.booleanValue()) {
            System.out.println(this.help.toString());
        }
        this.readSchemas = null;
        if (this.srcdir.size() > 0) {
            StringArrayList search = this.srcdir;
            if (this.workspace.length() > 0) {
                StringArrayList augmented = new StringArrayList();
                for (String dir : this.srcdir) {
                    augmented.add(this.workspace.toString() + "/" + dir);
                }
                search = augmented;
            }
            this.finder = new ConfigFinder(search.iterator());
        } else {
            this.finder = new ConfigFinder();
        }
        if (this.jars.size() > 0) {
            for (String jar : this.jars) {
                this.finder.addJarPrefix(jar);
            }
        }
        if (this.debug.booleanValue()) {
            this.finder.debug(true);
        }
        this.finder.addSuffix(".dms");
        this.finder.findConfigs();
        this.parser = new DmsSchemaParser(this.dmsSchema, this.finder);
        this.codeGenerator = new DmoGenerator(System.out);
        int longest = this.finder.getLongestName() + 4;
        this.docGenerator = new DmsHtmlDocGenerator();
        String f = "%-" + longest + "s";
        this.format = new PrintfFormat(f);
        this.classifier = new Classifier();
    }

    void initHelp() {
        String userHome = System.getProperty("user.home");
        this.help = new StringBuffer();
        this.help.append("dmogen -h -cfg -workspace -srcdir\n\n");
        this.help.append("The dmogen tool generates Dark Matter Objects based on a specified schema.\n");
        this.help.append("Schemas configurations (that end with a .dms extension) are recursivley discovered\n");
        this.help.append("in your development environment using information you provide in one of several ways.\n");
        this.help.append("\n");
        this.help.append("The default behaviour is to look for a .darkmatter folder in " + userHome + "\n");
        this.help.append("and to read the sourcedirs.txt file that resides there. The sourcedirs.txt file\n");
        this.help.append("specifies file paths to search, one path per line. The path must be fully qualified\n");
        this.help.append("i.e. C:/mydev/myproject/src\n");
        this.help.append("\n");
        this.help.append("The tool can also search .jar files that contain schemas defined by others. \n");
        this.help.append("Just specify a line with the jar file name (or the last part thereof). As long\n");
        this.help.append("the line ends with .jar, all jars that end with tha suffix will be searched for\n");
        this.help.append("schema configurations.\n");
        this.help.append("\n");
        this.help.append("You can also specify code locations on the command line via the -srcdir option.\n");
        this.help.append("\n");
        this.help.append("If you specify the -workspace option, this prefix will be placed in front of all \n");
        this.help.append("arguments to the -srcdir option.\n");
        this.help.append("\n");
        this.help.append("Or you can specify a configuration file (formatted like sourcedirs.txt) to load.\n");
        this.help.append("via the -cfg option.\n");
        this.help.append("\n");
        this.help.append("-h dumps the help information.\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("example: dmogen -workspace C:/eclipse/workspace -srcdir proj1/src proj2/src proj3/src\n");
        this.help.append("\n");
        this.help.append("\n");
    }

    public void run() throws DmcValueExceptionSet, DmcRuleExceptionSet, DmcNameClashException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String currLine = null;
        TokenArrayList tokens = null;
        if (this.autogen.booleanValue()) {
            for (ConfigVersion version : this.finder.getVersions().values()) {
                ConfigLocation loc = version.getLatestVersion();
                if (loc.isFromJAR()) continue;
                if (this.targets.contains(loc.getConfigName())) {
                    this.generateFromConfig(loc);
                    continue;
                }
                if (UtilityOptions.instance().quietWarnings()) continue;
                System.out.println("DMOGEN: " + loc.getConfigName() + " is not in the -targets list - not generating:  " + loc.getDirectory() + "\n");
            }
            try {
                if (this.docdir.length() > 0) {
                    if (this.workspace.length() > 0) {
                        this.docGenerator.dumpDocumentation(this.workspace.toString() + "/" + this.docdir.toString());
                    } else {
                        this.docGenerator.dumpDocumentation(this.docdir.toString());
                    }
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            return;
        }
        System.out.println("\n-- dmo generator utility --\n");
        System.out.println("Enter the name of a local (non-JAR) schema to generate its code\n");
        System.out.println("Enter ? for a list of schemas...\n\n");
        block8: while (true) {
            try {
                while (true) {
                    String s;
                    if ((s = in.readLine()) == null) {
                        return;
                    }
                    currLine = s.trim();
                    if (currLine.length() == 0) continue;
                    tokens = this.classifier.classify(currLine, false);
                    ConfigVersion config = this.finder.getConfig(tokens.nth(0).getValue());
                    ConfigLocation currLoc = null;
                    if (config != null) {
                        currLoc = config.getLatestVersion();
                    }
                    if (currLine.equals("?")) {
                        System.out.println("");
                        System.out.println(this.finder.getSearchInfo() + "\n");
                        for (ConfigVersion version : this.finder.getVersions().values()) {
                            ConfigLocation loc = version.getLatestVersion();
                            if (loc.getJarFilename() == null) {
                                System.out.println(this.format.sprintf(loc.getConfigName()) + "   version: " + loc.getVersion());
                                System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                                continue;
                            }
                            System.out.println(this.format.sprintf("JAR " + loc.getConfigName()) + " " + loc.getDirectory());
                            System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                        }
                        System.out.println("");
                        continue;
                    }
                    if (currLoc == null) {
                        System.err.println("\n" + currLine + " is not a recoginized schema name.\n\n");
                        continue;
                    }
                    if (currLoc.isFromJAR()) {
                        System.out.println("You can only generate code from schemas in your local environment.\n\n");
                        continue;
                    }
                    try {
                        this.readSchemas = new SchemaManager();
                        SchemaDefinition sd = this.parser.parseSchema(this.readSchemas, tokens.nth(0).getValue(), false);
                        FileUpdateManager.instance().reportProgress(System.out);
                        FileUpdateManager.instance().reportErrors(System.err);
                        FileUpdateManager.instance().generationStarting();
                        this.codeGenerator.generateCode(this.readSchemas, sd, currLoc);
                        FileUpdateManager.instance().generationComplete();
                        if (sd == null || !this.checkRules.booleanValue()) continue block8;
                        this.parser.checkRules(sd);
                        continue block8;
                    }
                    catch (ResultException e) {
                        System.err.println(e.toString());
                        continue;
                    }
                    catch (DmcValueException e) {
                        System.out.println(e.toString());
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("IOException:\n" + e.getMessage());
                System.exit(1);
                continue;
            }
            break;
        }
    }

    void generateFromConfig(ConfigLocation location) throws DmcNameClashException {
        try {
            this.readSchemas = new SchemaManager();
            SchemaDefinition sd = this.parser.parseSchema(this.readSchemas, location.getConfigName(), false);
            if (sd != null && this.checkRules.booleanValue()) {
                this.parser.checkRules(sd);
            }
            if (this.checkOnly.booleanValue()) {
                return;
            }
            if (this.docdir.length() > 0) {
                this.docGenerator.addReadSchemas(this.readSchemas);
            } else {
                FileUpdateManager.instance().reportProgress(System.out);
                FileUpdateManager.instance().reportErrors(System.err);
                FileUpdateManager.instance().generationStarting();
                this.codeGenerator.generateCode(this.readSchemas, sd, location);
                FileUpdateManager.instance().generationComplete();
            }
        }
        catch (ResultException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (DmcValueException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        catch (DmcRuleExceptionSet e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

