/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.types;

import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class EnumValue {
    Integer id;
    String name;
    String description;
    String label;

    public EnumValue() {
    }

    public EnumValue(EnumValue original) {
        this.id = original.id;
        this.name = original.name;
        this.description = original.description;
        this.label = original.label;
    }

    public EnumValue(String v) throws DmcValueException {
        this.set(v);
    }

    public void set(String v) throws DmcValueException {
        if (v == null) {
            throw new DmcValueException("null value passed to EnumValue.set()");
        }
        String value = v.replaceAll("\t", " ").trim();
        int space = value.indexOf(" ");
        if (space == -1) {
            throw new DmcValueException("Missing enum value name: " + value + " - value should be of the form: int enum_val_name [description] <: label>");
        }
        try {
            this.id = Integer.valueOf(value.substring(0, space));
        }
        catch (NumberFormatException e) {
            throw new DmcValueException("Invalid enum integer value: " + value + "\n" + e);
        }
        String remainder = value.substring(space + 1).trim();
        space = remainder.indexOf(" ");
        if (space == -1) {
            throw new DmcValueException("Missing enum description: " + value + " - value should be of the form: int enum_val_name [description] <: label>");
        }
        String tmp = remainder.substring(0, space);
        if (!Character.isLetter(tmp.charAt(0))) {
            throw new DmcValueException("Enum value name must start with a character: " + tmp);
        }
        this.name = tmp.toUpperCase();
        remainder = remainder.substring(space + 1).trim();
        int colon = remainder.indexOf(":");
        if (colon == -1) {
            this.description = remainder.trim();
        } else {
            this.description = remainder.substring(0, colon).trim();
            if (colon + 1 == remainder.length()) {
                throw new DmcValueException("Missing label value: " + value + " - value should be of the form: int enum_val_name [description] <: label>");
            }
            this.label = remainder.substring(colon + 1).trim();
        }
    }

    public String toString() {
        if (this.label == null) {
            return this.id + " " + this.name + " " + this.description;
        }
        return this.id + " " + this.name + " " + this.description + " : " + this.label;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.id);
        dos.writeUTF(this.name);
        dos.writeUTF(this.description);
        dos.writeUTF(this.label);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.id = dis.readInt();
        this.name = dis.readUTF();
        this.description = dis.readUTF();
        this.label = dis.readUTF();
    }
}

