/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.generated.dmw.ActionDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DmoActionFormatter {
    String fileHeader;
    PrintStream progress;

    public DmoActionFormatter() {
    }

    public DmoActionFormatter(PrintStream o) {
        this.progress = o;
    }

    public void setFileHeader(String fh) {
        this.fileHeader = fh;
    }

    public void dumpActions(SchemaDefinition sd, String outdir) throws IOException, ResultException {
        ActionDefinitionIterableDMW actions = sd.getActionDefList();
        if (actions != null) {
            while (actions.hasNext()) {
                ActionDefinition action = (ActionDefinition)actions.next();
                this.dumpAction(action, outdir);
            }
        }
    }

    private void dumpAction(ActionDefinition ad, String outdir) throws IOException, ResultException {
        String cappedName = this.capTheName(ad.getName().getNameString());
        ArrayList<AttributeDefinition> allAttr = new ArrayList<AttributeDefinition>();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, cappedName + "ATI.java");
        if (this.fileHeader != null) {
            out.write(this.fileHeader);
        }
        String schemaPackage = ((SchemaDefinitionDMW)ad.getDefinedIn()).getSchemaPackage();
        out.write("package " + schemaPackage + ".generated.dmo;\n\n");
        out.write("import java.io.Serializable;\n");
        out.write("import org.dmd.dms.extended.ActionTriggerInfo;\n");
        out.write("import org.dmd.dmc.DmcValueExceptionSet;\n");
        BooleanVar anyMVAttributes = new BooleanVar(false);
        BooleanVar anySVAttributes = new BooleanVar(false);
        out.write(GenUtility.getImports(ad, allAttr, anySVAttributes, anyMVAttributes) + "\n");
        boolean anySVRef = false;
        boolean anyMVRef = false;
        for (AttributeDefinition attributeDefinition : allAttr) {
            switch (attributeDefinition.getValueType()) {
                case SINGLE: {
                    anySVRef = true;
                }
                case MULTI: 
                case HASHSET: 
                case TREESET: {
                    anyMVRef = true;
                    break;
                }
                case HASHMAPPED: {
                    break;
                }
            }
        }
        out.write("import org.dmd.dmc.DmcObject;\n");
        if (anySVRef) {
            out.write("import org.dmd.dms.generated.types.DmcTypeDmcObjectSV;\n");
        }
        if (anyMVRef) {
            out.write("import org.dmd.dms.generated.types.DmcTypeDmcObjectMV;\n");
        }
        out.write("/**\n");
        out.write(" * This is the generated ActionTriggerInfo derivative for the " + ad.getName() + " action.\n");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)ad.getDefinedIn()).getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("@SuppressWarnings(\"serial\")\n");
        out.write("public class " + cappedName + "ATI extends ActionTriggerInfo implements Serializable {\n\n");
        out.write("\n");
        out.write("    public " + cappedName + "ATI(){\n");
        out.write("        super(\"" + cappedName + "\",\"" + ad.getName() + "\");\n");
        out.write("    }\n");
        out.write("\n");
        StringBuffer sb = new StringBuffer();
        for (AttributeDefinition attr : allAttr) {
            switch (attr.getValueType()) {
                case SINGLE: {
                    if (attr.getType().getIsRefType().booleanValue()) {
                        GenUtility.formatSVObjectAccess(attr, sb);
                        break;
                    }
                    GenUtility.formatSV(attr, sb);
                    break;
                }
                case MULTI: 
                case HASHSET: 
                case TREESET: {
                    if (attr.getType().getIsRefType().booleanValue()) {
                        GenUtility.formatMVObjectAccess(attr, sb);
                        break;
                    }
                    GenUtility.formatMV(attr, sb);
                    break;
                }
                case HASHMAPPED: {
                    break;
                }
            }
        }
        out.write(sb.toString());
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void checkParams() throws DmcValueExceptionSet {\n");
        if (ad.getMustParmSize() > 0) {
            out.write("        DmcValueExceptionSet ex = null;\n\n");
            AttributeDefinitionIterableDMW attributeDefinitionIterableDMW = ad.getMustParm();
            while (attributeDefinitionIterableDMW.hasNext()) {
                AttributeDefinition attr;
                attr = (AttributeDefinition)attributeDefinitionIterableDMW.next();
                out.write("        if (get(" + attr.getDMSAGReference() + ") == null){\n");
                out.write("            if (ex == null)\n");
                out.write("                ex = new DmcValueExceptionSet();\n");
                out.write("            ex.add(new DmcValueException(\"" + cappedName + "ATI - missing mandatory parameter: " + attr.getName() + "\"));\n");
                out.write("        }\n");
            }
            out.write("        if (ex != null)\n");
            out.write("            throw(ex);\n");
        } else {
            out.write("        // No mandatory parameters to check\n");
        }
        out.write("  }\n\n");
        out.write("    @Override\n");
        out.write("    public boolean isInstanceOf(DmcObject object) {\n");
        out.write("        if (object instanceof " + cappedName + "ATI)\n");
        out.write("            return(true);\n");
        out.write("        return(false);\n");
        out.write("    }\n\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
    }

    String capTheName(String value) {
        StringBuffer name = new StringBuffer();
        name.append(value);
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return name.toString();
    }
}

