/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TreeMap;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.util.TypeAndAttr;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;

public class DmoAttributeFactoryFormatter {
    PrintStream progress;
    TreeMap<String, AttributeDefinition> attributes;
    TreeMap<String, TypeAndAttr> typeAndAttr;

    public DmoAttributeFactoryFormatter(PrintStream p) {
        this.progress = p;
    }

    public void dumpFactory(SchemaManager sm, SchemaDefinition sd, String dmodir) throws IOException {
        String factoryName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "AttributeFactoryAG";
        this.attributes = new TreeMap();
        this.typeAndAttr = new TreeMap();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, factoryName + ".java");
        this.dumpHeader(out, sd);
        AttributeDefinitionIterableDMW ads = sd.getAttributeDefList();
        if (ads != null) {
            while (ads.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)ads.next();
                if (!ad.getType().getIsNameType().booleanValue()) continue;
                this.attributes.put(ad.getName().getNameString(), ad);
                TypeAndAttr ta = new TypeAndAttr(ad.getType(), ad.getValueType(), ad.getIndexSize());
                this.typeAndAttr.put(ta.name, ta);
                DebugInfo.debug(ad.getName().getNameString());
            }
            out.write("import java.util.HashMap;\n");
            for (TypeAndAttr ta : this.typeAndAttr.values()) {
                out.write("import " + ta.getImport() + ";\n");
            }
            out.write("\n");
            out.write("public class " + factoryName + " {\n\n");
            for (AttributeDefinition ad : this.attributes.values()) {
                out.write("    public final static DmcAttributeInfo __" + ad.getName().getNameString() + " = new DmcAttributeInfo(");
                out.write("\"" + ad.getName().getNameString() + "\"");
                out.write(", " + ad.getDmdID());
                out.write(", \"" + ad.getType().getName().getNameString() + "\"");
                out.write(", ValueTypeEnum." + (Object)((Object)ad.getValueType()));
                out.write(", true");
                out.write(");\n");
            }
            out.write("\n");
            out.write("    static  HashMap<String ,DmcAttributeInfo> _SmAp;\n");
            out.write("\n");
            out.write("    static {\n");
            out.write("        _SmAp = new HashMap<String ,DmcAttributeInfo>();\n");
            for (AttributeDefinition ad : this.attributes.values()) {
                out.write("        _SmAp.put(__" + ad.getName().getNameString() + ".name,__" + ad.getName().getNameString() + ");\n");
            }
            out.write("\n");
            out.write("    }\n");
            out.write("\n");
            out.write("    public DmcAttributeInfo getAttributeInfo(String nameClass){\n");
            out.write("        return(_SmAp.get(nameClass));\n");
            out.write("    }\n");
            out.write("\n");
            out.write("\n");
            for (AttributeDefinition ad : this.attributes.values()) {
                String tn = GeneratorUtils.getClassNameFromImport(ad.getType().getTypeClassName());
                out.write("    public static " + tn + this.suffix(ad.getValueType()) + " get" + GeneratorUtils.dotNameToCamelCase(ad.getName().getNameString()) + "(){\n");
                out.write("        " + tn + this.suffix(ad.getValueType()) + " rc = new " + tn + this.suffix(ad.getValueType()) + "();\n");
                out.write("        rc .setAttributeInfo(__" + ad.getName().getNameString() + ");\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
            }
        }
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    String suffix(ValueTypeEnum vte) {
        String rc = null;
        switch (vte) {
            case SINGLE: {
                rc = "SV";
                break;
            }
            case MULTI: {
                rc = "MV";
                break;
            }
            case HASHMAPPED: 
            case TREEMAPPED: {
                rc = "MAP";
                break;
            }
            case HASHSET: 
            case TREESET: {
                rc = "SET";
            }
        }
        return rc;
    }

    void dumpHeader(BufferedWriter out, SchemaDefinition sd) throws IOException {
        out.write("package " + sd.getSchemaPackage() + ".generated.dmo;\n\n");
        out.write("import org.dmd.dmc.*;\n");
        out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        out.write("\n");
    }
}

