/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SliceDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DmoAttributeSchemaFormatter {
    PrintStream progress;

    public DmoAttributeSchemaFormatter(PrintStream p) {
        this.progress = p;
    }

    public void dumpSchema(SchemaDefinition sd, String dmodir, String fake) throws IOException {
        String schemaName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "ASAG";
        TreeMap<String, AttributeDefinition> attributes = new TreeMap<String, AttributeDefinition>();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + ".java");
        StringBuffer nameBuilders = new StringBuffer();
        this.dumpHeaderASAG(out, sd.getSchemaPackage(), sd, nameBuilders);
        AttributeDefinitionIterableDMW ads = sd.getAttributeDefList();
        if (ads != null) {
            while (ads.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)ads.next();
                attributes.put(ad.getName().getNameString(), ad);
            }
            out.write("\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + schemaName + " implements DmcAttributeSchemaIF {\n\n");
            out.write("\n");
            out.write("    static String schemaName = \"" + sd.getName().getNameString() + "\";\n");
            out.write("\n");
            for (AttributeDefinition ad : attributes.values()) {
                out.write("    public final static DmcAttributeInfo __" + ad.getName().getNameString() + " = new DmcAttributeInfo(");
                out.write("\"" + ad.getName().getNameString() + "\"");
                out.write(", " + ad.getDmdID());
                out.write(", \"" + ad.getType().getName().getNameString() + "\"");
                out.write(", ValueTypeEnum." + (Object)((Object)ad.getValueType()));
                out.write(", DataTypeEnum." + (Object)((Object)ad.getDataType()));
                out.write(", true");
                out.write(");\n");
            }
            out.write("\n");
            for (SliceDefinition slice : sd.getSliceDefList()) {
                out.write("    public final static DmcSliceInfo __" + slice.getName() + " = new DmcSliceInfo(\"" + slice.getName() + "\");\n");
            }
            this.writeCommonPart1(out);
            for (AttributeDefinition ad : attributes.values()) {
                out.write("        _SmAp.put(__" + ad.getName().getNameString() + ".id,__" + ad.getName().getNameString() + ");\n");
            }
            out.write(nameBuilders.toString());
            for (SliceDefinition slice : sd.getSliceDefList()) {
                out.write("\n");
                for (AttributeDefinition ad : slice.getSelectAttribute()) {
                    out.write("        __" + slice.getName().getNameString() + ".addAttributeID(" + ad.getDmdID() + ");\n");
                }
                out.write("        _SImAp.put(\"" + slice.getName() + "\",__" + slice.getName().getNameString() + ");\n");
            }
            this.writeCommonPart2(out, schemaName);
        }
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public void dumpSchema(String sn, String schemaPackage, TreeMap<String, DmcUncheckedObject> attributes, TreeMap<String, DmcUncheckedObject> types, String dmodir) throws IOException, ResultException {
        String schemaName = GeneratorUtils.dotNameToCamelCase(sn) + "ASAG";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + ".java");
        this.dumpHeader(out, schemaPackage);
        StringBuilder nameBuilders = new StringBuilder();
        if (types != null) {
            for (DmcUncheckedObject td : types.values()) {
                String tname = td.getSV("name");
                String isNameType = td.getSV("isNameType");
                if (isNameType == null) continue;
                String nameAttributeDef = td.getSV("nameAttributeDef");
                if (nameAttributeDef == null) {
                    throw new IllegalStateException("TypeDefinition " + tname + "  does not have a designated naming attribute.");
                }
                nameBuilders.append("        _NmAp.put(DmcType" + tname + "STATIC.instance.getNameClass(),DmcType" + tname + "STATIC.instance);\n");
            }
        }
        if (attributes != null) {
            String n;
            out.write("\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + schemaName + " implements DmcAttributeSchemaIF {\n\n");
            out.write("\n");
            out.write("    static String schemaName = \"" + sn + "\";\n");
            out.write("\n");
            for (DmcUncheckedObject ad : attributes.values()) {
                n = ad.getSV("name");
                String t = ad.getSV("type");
                String ID = ad.getSV("dmdID");
                String mv = ad.getSV("valueType");
                this.writeAttributeInfo(out, n, ID, t, mv, "false");
            }
            this.writeCommonPart1(out);
            for (DmcUncheckedObject ad : attributes.values()) {
                n = ad.getSV("name");
                out.write("        _SmAp.put(__" + n + ".id,__" + n + ");\n");
            }
            out.write(nameBuilders.toString());
            this.writeCommonPart2(out, schemaName);
        }
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    void writeCommonPart1(BufferedWriter out) throws IOException {
        out.write("\n");
        out.write("    static  HashMap<Integer ,DmcAttributeInfo> _SmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String ,DmcNameBuilderIF> _NmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String ,DmcSliceInfo> _SImAp;\n");
        out.write("\n");
        out.write("    static {\n");
        out.write("        _SmAp = new HashMap<Integer ,DmcAttributeInfo>();\n");
        out.write("\n");
        out.write("        _NmAp = new HashMap<String ,DmcNameBuilderIF>();\n");
        out.write("\n");
        out.write("        _SImAp = new HashMap<String ,DmcSliceInfo>();\n");
        out.write("\n");
    }

    void writeCommonPart2(BufferedWriter out, String schemaName) throws IOException {
        out.write("\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    static  " + schemaName + " instance;\n");
        out.write("\n");
        out.write("    protected " + schemaName + " (){\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public static " + schemaName + " instance(){\n");
        out.write("        if (instance == null)\n");
        out.write("            instance = new " + schemaName + "();\n");
        out.write("        return(instance);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public DmcAttributeInfo getAttributeInfo(Integer id){\n");
        out.write("        return(_SmAp.get(id));\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcAttributeInfo> getInfo(){\n");
        out.write("        return(_SmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcNameBuilderIF> getNameBuilders(){\n");
        out.write("        return(_NmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcSliceInfo> getSliceInfo(){\n");
        out.write("        return(_SImAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public String getSchemaName(){\n");
        out.write("        return(schemaName);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
    }

    void dumpHeader(BufferedWriter out, String schemaPackage) throws IOException {
        out.write("package " + schemaPackage + ".generated.dmo;\n\n");
        out.write("import java.util.HashMap;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.*;\n");
        out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        out.write("import org.dmd.dms.generated.enums.DataTypeEnum;\n");
        out.write("import org.dmd.dms.generated.types.*;\n");
        out.write("\n");
    }

    void dumpHeaderASAG(BufferedWriter out, String schemaPackage, SchemaDefinition sd, StringBuffer nameBuilders) throws IOException {
        TypeDefinitionIterableDMW tds;
        out.write("package " + schemaPackage + ".generated.dmo;\n\n");
        out.write("import java.util.HashMap;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.*;\n");
        DmcAttribute<?> adef = sd.getDMO().get(MetaDMSAG.__attributeDefList);
        if (adef != null) {
            out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
            out.write("import org.dmd.dms.generated.enums.DataTypeEnum;\n");
        }
        if ((tds = sd.getTypeDefList()) != null) {
            while (tds.hasNext()) {
                TypeDefinition td = (TypeDefinition)tds.next();
                if (!td.getIsNameType().booleanValue()) continue;
                if (td.getNameAttributeDef() == null) {
                    throw new IllegalStateException("TypeDefinition " + td.getName() + "  does not have a designated naming attribute.");
                }
                String adn = td.getName().getNameString();
                nameBuilders.append("        _NmAp.put(DmcType" + adn + "STATIC.instance.getNameClass(),DmcType" + adn + "STATIC.instance);\n");
            }
        }
        if (nameBuilders.length() > 0) {
            out.write("import " + schemaPackage + ".generated.types.*;\n");
        }
        out.write("\n");
    }

    void writeAttributeInfo(BufferedWriter out, String n, String ID, String t, String mv, String opt) throws IOException {
        out.write("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.write("\"" + n + "\",");
        out.write(ID + ",");
        out.write("\"" + t + "\",");
        if (mv == null) {
            out.write("ValueTypeEnum.SINGLE,");
        } else {
            out.write("ValueTypeEnum.MULTI,");
        }
        out.write("DataTypeEnum.PERSISTENT,");
        out.write(opt + ");\n");
    }
}

