/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.RuleName;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.SliceDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class DmoCompactSchemaFormatter {
    private static final int OBJECT_INIT_SPLIT = 100;
    PrintStream progress;
    int uniqueNum;

    public DmoCompactSchemaFormatter(PrintStream p) {
        this.progress = p;
        this.uniqueNum = 1;
    }

    /*
     * WARNING - void declaration
     */
    public void dumpSchema(SchemaManager sm, SchemaDefinition sd, String dmodir) throws IOException, ResultException, DmcNameClashException, IllegalArgumentException, DmcValueException {
        TreeMap<RuleName, RuleIF> resolvedRules;
        Iterator<DmcUncheckedObject> rules;
        TypeDefinition td;
        TypeDefinitionIterableDMW tds;
        AttributeDefinitionIterableDMW ads;
        String schemaName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "DMSAG";
        TreeMap<String, ClassDefinition> classes = new TreeMap<String, ClassDefinition>();
        TreeMap<String, AttributeDefinition> attributes = new TreeMap<String, AttributeDefinition>();
        TreeMap<String, TypeDefinition> types = new TreeMap<String, TypeDefinition>();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + ".java");
        StringBuffer nameBuilders = new StringBuffer();
        StringBuffer filterBuilders = new StringBuffer();
        this.dumpHeaderDMSAG(out, sm, sd.getSchemaPackage(), sd, nameBuilders, filterBuilders);
        ClassDefinitionIterableDMW cds = sd.getClassDefList();
        if (cds != null) {
            while (cds.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cds.next();
                classes.put(cd.getName().getNameString(), cd);
            }
        }
        if ((ads = sd.getAttributeDefList()) != null) {
            while (ads.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)ads.next();
                attributes.put(ad.getName().getNameString(), ad);
            }
        }
        if ((tds = sd.getTypeDefList()) != null) {
            while (tds.hasNext()) {
                td = (TypeDefinition)tds.next();
                types.put(td.getName().getNameString(), td);
            }
        }
        if ((tds = sd.getInternalTypeDefList()) != null) {
            while (tds.hasNext()) {
                td = (TypeDefinition)tds.next();
                types.put(td.getName().getNameString(), td);
            }
        }
        this.dumpAttributeMapInitializer(sd, dmodir, attributes);
        this.dumpClassMapInitializer(sd, dmodir, classes);
        int objectInitializers = this.dumpSchemaObjectInitializers(sd, dmodir);
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + schemaName + " implements DmcCompactSchemaIF {\n\n");
        out.write("\n");
        out.write("    static String schemaName = \"" + sd.getName().getNameString() + "\";\n");
        out.write("\n");
        out.write("\n");
        out.write("    static int schemaBaseID = " + sd.getSchemaBaseID() + ";\n");
        out.write("\n");
        out.write("\n");
        out.write("    static int schemaIDRange = " + sd.getSchemaIDRange() + ";\n");
        out.write("\n");
        int max = sd.getSchemaBaseID() + sd.getSchemaIDRange();
        out.write("\n");
        out.write("    static int schemaMaxID = " + max + ";\n");
        out.write("\n");
        for (AttributeDefinition ad : attributes.values()) {
            void var18_22;
            out.write("    public final static DmcAttributeInfo __" + ad.getName().getNameString() + " = new DmcAttributeInfo(");
            out.write("\"" + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "\"");
            out.write(", \"" + ad.getName().getNameString() + "\"");
            out.write(", " + ad.getDmdID());
            out.write(", \"" + ad.getType().getName().getNameString() + "\"");
            out.write(", ValueTypeEnum." + (Object)((Object)ad.getValueType()));
            out.write(", DataTypeEnum." + (Object)((Object)ad.getDataType()));
            String string = ", 0";
            String weakReference = ", false";
            if (ad.getIndexSize() != null) {
                String string2 = ", " + ad.getIndexSize();
            }
            if (ad.getWeakReference() != null) {
                weakReference = ", " + ad.getWeakReference();
            }
            out.write((String)var18_22 + weakReference + ");\n");
        }
        if (types.size() > 0) {
            out.write("\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            for (Object td2 : types.values()) {
                if (!((TypeDefinitionDMW)td2).getInternallyGenerated().booleanValue()) {
                    if (!((TypeDefinitionDMW)td2).getIsNameType().booleanValue()) {
                        out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getName().getNameString() + "\", OriginalTypeEnum.TYPE);\n");
                        continue;
                    }
                    out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getName().getNameString() + "\", OriginalTypeEnum.NAMETYPE);\n");
                    continue;
                }
                if (((TypeDefinitionDMW)td2).getIsEnumType().booleanValue()) {
                    out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getName().getNameString() + "\", OriginalTypeEnum.ENUM);\n");
                    continue;
                }
                if (((TypeDefinitionDMW)td2).getIsExtendedRefType().booleanValue()) {
                    out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getName().getNameString() + "\", OriginalTypeEnum.EXTREF);\n");
                    continue;
                }
                if (((TypeDefinitionDMW)td2).getIsRefType().booleanValue()) {
                    if (((TypeDefinitionDMW)td2).getOriginalClass().getIsNamedBy() == null) {
                        out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + "\", OriginalTypeEnum.OBJECT);\n");
                        continue;
                    }
                    out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + "\", OriginalTypeEnum.REFERENCE);\n");
                    continue;
                }
                if (((TypeDefinitionDMW)td2).getOriginalClass() == null) {
                    out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getName().getNameString() + "\", OriginalTypeEnum.COMPLEXTYPE);\n");
                    continue;
                }
                out.write("    public final static DmcTypeInfo __type_" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + " = new DmcTypeInfo(\"" + ((TypeDefinitionDMW)td2).getOriginalClass().getName().getNameString() + "\", OriginalTypeEnum.COMPLEXTYPE);\n");
            }
        }
        if (classes.size() > 0) {
            out.write("\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            TreeMap<String, ClassNode> hierarchy = this.getHierarchy(classes.values().iterator());
            for (ClassNode classNode : hierarchy.values()) {
                classNode.writeClassInfo(out);
            }
        }
        if (sd.getSliceDefListSize() > 0) {
            out.write("\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            for (SliceDefinition slice : sd.getSliceDefList()) {
                out.write("    public final static DmcSliceInfo __" + slice.getName() + " = new DmcSliceInfo(\"" + slice.getName() + "\");\n");
                for (AttributeDefinition ad : slice.getSelectAttribute()) {
                    out.write("    // " + ad.getName() + "\n");
                }
                out.write("\n");
            }
        }
        if ((rules = sd.getParsedRules()) != null) {
            out.write("\n");
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            while (rules.hasNext()) {
                DmcUncheckedObject ruleData = rules.next();
                String string = ruleData.getConstructionClass();
                int dataPos = string.indexOf("Data");
                String ruleClass = string.substring(0, dataPos);
                String ruleName = ruleData.getSV("ruleName");
                out.write("    public final static " + ruleClass + " __" + ruleName + ";\n");
            }
        }
        this.writeCommonPart1(out);
        out.write("        " + schemaName + "AMAP.initSmAp(_SmAp);\n\n");
        out.write("        " + schemaName + "CMAP.initCmAp(_CmAp);\n\n");
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    static {\n\n");
        out.write(nameBuilders.toString());
        for (SliceDefinition sliceDefinition : sd.getSliceDefList()) {
            out.write("\n");
            for (AttributeDefinition ad : sliceDefinition.getSelectAttribute()) {
                out.write("        __" + sliceDefinition.getName().getNameString() + ".addAttributeID(" + ad.getDmdID() + ");\n");
            }
            out.write("        _SImAp.put(\"" + sliceDefinition.getName() + "\",__" + sliceDefinition.getName().getNameString() + ");\n");
        }
        out.write("\n");
        for (int fileNumber = 1; fileNumber <= objectInitializers; ++fileNumber) {
            out.write("        " + schemaName + "_INIT_" + fileNumber + ".initDefinitions();\n");
        }
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    static {\n\n");
        if (sd.getRuleDefinitionListSize() > 0) {
            out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("        // These instantiations are merely meant to ensure that you've overloaded\n");
            out.write("        // the base rule implementations\n");
            for (RuleDefinition ruleDefinition : sd.getRuleDefinitionList()) {
                out.write("        @SuppressWarnings(\"unused\")\n");
                out.write("        " + ruleDefinition.getName() + " " + ruleDefinition.getName() + "Instance = new " + ruleDefinition.getName() + "(new " + ruleDefinition.getName() + "DataDMO());\n");
            }
        }
        if ((resolvedRules = sd.getResolvedRules()) != null && resolvedRules.size() > 0) {
            out.write("\n");
            PrintfFormat printfFormat = new PrintfFormat("%-28s");
            out.write("        // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("        try{\n");
            for (RuleIF rule : resolvedRules.values()) {
                RuleDataDMO rd = rule.getRuleDataDMO();
                int dataPos = rd.getConstructionClassName().lastIndexOf("Data");
                String ruleClass = rd.getConstructionClassName().substring(0, dataPos);
                out.write("            " + rd.getConstructionClassName() + "DMO _" + rd.getRuleName() + "Data = new " + rd.getConstructionClassName() + "DMO();\n");
                this.setAttributeValues(out, sm, rd, printfFormat);
                out.write("            __" + rd.getRuleName() + " = new " + ruleClass + "(_" + rd.getRuleName() + "Data);\n\n");
                out.write("            _RmAp.add(__" + rd.getRuleName() + ");\n\n");
            }
            out.write("        } catch(DmcValueException ex){\n");
            out.write("            throw(new IllegalStateException(ex));\n");
            out.write("        }\n");
        }
        this.writeCommonPart2(out, schemaName);
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    void dumpAttributeMapInitializer(SchemaDefinition sd, String dmodir, TreeMap<String, AttributeDefinition> attributes) throws IOException, ResultException {
        String schemaName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "DMSAG";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + "AMAP.java");
        out.write("package " + sd.getSchemaPackage() + ".generated.dmo;\n\n");
        ImportManager manager = new ImportManager();
        manager.addImport("java.util.HashMap", "For storage of schema info");
        manager.addImport("org.dmd.dmc.*", "Basic DMC stuff");
        out.write(manager.getFormattedImports());
        out.write("\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + schemaName + "AMAP {\n\n");
        out.write("    static protected void initSmAp(HashMap<Integer, DmcAttributeInfo> _SmAp){\n");
        for (AttributeDefinition ad : attributes.values()) {
            out.write("        _SmAp.put(" + schemaName + ".__" + ad.getName().getNameString() + ".id," + schemaName + ".__" + ad.getName().getNameString() + ");\n");
        }
        out.write("    }\n\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    int dumpSchemaObjectInitializers(SchemaDefinition sd, String dmodir) throws IOException, ResultException {
        if (sd.getClassDefListSize() == 0) {
            return 0;
        }
        int fileCount = sd.getClassDefListSize() / 100;
        int remainder = sd.getClassDefListSize() % 100;
        if (remainder != 0) {
            ++fileCount;
        }
        ClassDefinitionIterableDMW classIT = sd.getClassDefList();
        for (int fileNumber = 1; fileNumber <= fileCount; ++fileNumber) {
            String schemaName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "DMSAG";
            ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + "_INIT_" + fileNumber + ".java");
            out.write("package " + sd.getSchemaPackage() + ".generated.dmo;\n\n");
            ImportManager manager = new ImportManager();
            String init = this.getFormattedObjects(sd, classIT, manager);
            out.write(manager.getFormattedImports());
            out.write("\n\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + schemaName + "_INIT_" + fileNumber + " {\n\n");
            out.write("    static protected void initDefinitions(){\n");
            out.write(init + "\n");
            out.write("    }\n\n");
            out.write("}\n\n");
            ((BufferedWriter)out).close();
        }
        return fileCount;
    }

    String getFormattedObjects(SchemaDefinition sd, Iterator<ClassDefinition> classIT, ImportManager manager) {
        StringBuilder sb = new StringBuilder();
        manager.addImport("org.dmd.dms.generated.dmo.MetaDMSAG", "For Meta references");
        int currentObject = 0;
        while (classIT.hasNext()) {
            ++currentObject;
            ClassDefinition cd = classIT.next();
            for (AttributeDefinition ad : cd.getMust()) {
                manager.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Required attribute from " + ((SchemaDefinition)ad.getDefinedIn()).getDMSASGName());
            }
            for (AttributeDefinition ad : cd.getMay()) {
                manager.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Optional attribute (1): " + ad.getObjectName().getNameString() + " from " + ((SchemaDefinition)ad.getDefinedIn()).getDMSASGName());
            }
            sb.append("    // " + currentObject + " -- " + cd.getName() + "\n");
            String attr = null;
            Iterator<AttributeDefinition> attrIT = null;
            for (AttributeDefinition ad : cd.getAllMust().values()) {
                attr = ((SchemaDefinition)ad.getDefinedIn()).getDMSASGName() + ".__" + ad.getName();
                sb.append("        " + ((SchemaDefinition)cd.getDefinedIn()).getDMSASGName() + ".__" + cd.getName() + ".addMust(" + attr + ");\n");
            }
            for (AttributeDefinition ad : cd.getAllMay().values()) {
                attr = ((SchemaDefinition)ad.getDefinedIn()).getDMSASGName() + ".__" + ad.getName();
                sb.append("        " + ((SchemaDefinition)cd.getDefinedIn()).getDMSASGName() + ".__" + cd.getName() + ".addMay(" + attr + ");\n");
            }
            sb.append("\n");
            if (currentObject != 100) continue;
            break;
        }
        return sb.toString();
    }

    void dumpClassMapInitializer(SchemaDefinition sd, String dmodir, TreeMap<String, ClassDefinition> classes) throws IOException, ResultException {
        String schemaName = GeneratorUtils.dotNameToCamelCase(sd.getName().getNameString()) + "DMSAG";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + "CMAP.java");
        out.write("package " + sd.getSchemaPackage() + ".generated.dmo;\n\n");
        ImportManager manager = new ImportManager();
        manager.addImport("java.util.HashMap", "For storage of schema info");
        manager.addImport("org.dmd.dmc.*", "Basic DMC stuff");
        out.write(manager.getFormattedImports());
        out.write("\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + schemaName + "CMAP {\n\n");
        out.write("    static protected void initCmAp(HashMap<Integer, DmcClassInfo> _CmAp){\n");
        for (ClassDefinition cd : classes.values()) {
            out.write("        _CmAp.put(" + schemaName + ".__" + cd.getName().getNameString() + ".id," + schemaName + ".__" + cd.getName().getNameString() + ");\n");
        }
        out.write("    }\n\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    private void setAttributeValues(BufferedWriter out, SchemaManager sm, RuleDataDMO rd, PrintfFormat pf) throws IllegalArgumentException, IOException, ResultException, DmcNameClashException, DmcValueException {
        String objName = rd.getRuleName().getNameString() + "Data";
        ClassDefinition cd = sm.isClass(rd.getConstructionClassName());
        AttributeDefinition attrDef = null;
        Iterator<DmcAttribute<?>> attributes = rd.getAttributeIterator();
        while (attributes.hasNext()) {
            DmcAttribute<?> attr = attributes.next();
            attrDef = sm.isAttribute(attr.getID());
            if (attr.getAttributeInfo().id == MetaDMSAG.__objectClass.id) continue;
            DefinitionName adn = this.getDefinitionName(rd.getConstructionClassName(), attr.getName());
            if (cd.isAllowedAttribute(adn)) {
                String attrNameCapped = Manipulator.capFirstChar(attr.getName());
                if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                    out.write("            _" + pf.sprintf(objName));
                    out.write(".set" + attrNameCapped + "(");
                    out.write("\"" + attr.getSV().toString() + "\");\n");
                    continue;
                }
                Iterator<?> vals = attr.getMV();
                while (vals.hasNext()) {
                    Object val = vals.next();
                    out.write("            _" + pf.sprintf(objName));
                    out.write(".add" + attrNameCapped + "(");
                    out.write("\"" + val.toString() + "\");\n");
                }
                continue;
            }
            out.write(attrDef.getValueModificationStatement(this.uniqueNum, "            ", "            _" + objName, attr));
            ++this.uniqueNum;
        }
        out.write("\n");
    }

    DefinitionName getDefinitionName(String cn, String dn) throws ResultException {
        DefinitionName rc = null;
        try {
            rc = new DefinitionName(dn);
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException("This is not a legal attribute name: " + dn);
            ex.moreMessages("DefinitionNames must begin with an alpha character and contain only leters and numbers.");
            ex.moreMessages("This occurred while formatting the compact schema for class: " + cn);
            throw ex;
        }
        return rc;
    }

    public void dumpSchema(String sn, String schemaPackage, TreeMap<String, DmcUncheckedObject> classes, TreeMap<String, DmcUncheckedObject> attributes, TreeMap<String, DmcUncheckedObject> types, ArrayList<DmcUncheckedObject> rules, String dmodir, int baseID, int idRange) throws IOException, ResultException {
        String n;
        String schemaName = GeneratorUtils.dotNameToCamelCase(sn) + "DMSAG";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dmodir, schemaName + ".java");
        this.dumpHeaderMETA(out, schemaPackage);
        StringBuilder nameBuilders = new StringBuilder();
        if (types != null) {
            for (DmcUncheckedObject dmcUncheckedObject : types.values()) {
                String string = dmcUncheckedObject.getSV("name");
                String string2 = dmcUncheckedObject.getSV("isNameType");
                if (string2 == null) continue;
                String nameAttributeDef = dmcUncheckedObject.getSV("nameAttributeDef");
                if (nameAttributeDef == null) {
                    throw new IllegalStateException("TypeDefinition " + string + "  does not have a designated naming attribute.");
                }
                nameBuilders.append("        _NmAp.put(DmcType" + string + "STATIC.instance.getNameClass(),DmcType" + string + "STATIC.instance);\n");
            }
        }
        StringBuilder filterBuilders = new StringBuilder();
        if (types != null) {
            for (DmcUncheckedObject dmcUncheckedObject : types.values()) {
                String string = dmcUncheckedObject.getSV("name");
                String isFilterType = dmcUncheckedObject.getSV("isFilterType");
                if (isFilterType == null) continue;
                String filterAttributeDef = dmcUncheckedObject.getSV("filterAttributeDef");
                if (filterAttributeDef == null) {
                    throw new IllegalStateException("TypeDefinition " + string + "  does not have a designated filter attribute.");
                }
                filterBuilders.append("        _FmAp.put(DmcType" + string + "STATIC.instance.getFilterClass(),DmcType" + string + "STATIC.instance);\n");
            }
        }
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + schemaName + " implements DmcCompactSchemaIF {\n\n");
        out.write("\n");
        out.write("    static String schemaName = \"" + sn + "\";\n");
        out.write("\n");
        out.write("\n");
        out.write("    static int schemaBaseID = " + baseID + ";\n");
        out.write("\n");
        out.write("\n");
        out.write("    static int schemaIDRange = " + idRange + ";\n");
        out.write("\n");
        int n2 = baseID + idRange;
        out.write("\n");
        out.write("    static int schemaMaxID = " + n2 + ";\n");
        out.write("\n");
        if (attributes != null) {
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            for (DmcUncheckedObject dmcUncheckedObject : attributes.values()) {
                n = dmcUncheckedObject.getSV("name");
                String t = dmcUncheckedObject.getSV("type");
                String ID = dmcUncheckedObject.getSV("dmdID");
                String mv = dmcUncheckedObject.getSV("valueType");
                String indexSize = dmcUncheckedObject.getSV("indexSize");
                String weakReference = dmcUncheckedObject.getSV("weakReference");
                String dataType = "PERSISTENT";
                if (dmcUncheckedObject.get("dataType") != null) {
                    dataType = dmcUncheckedObject.getSV("dataType");
                }
                if (indexSize == null) {
                    indexSize = "0";
                }
                if (weakReference == null) {
                    weakReference = "false";
                }
                this.writeAttributeInfoMETA(out, n, ID, t, mv, dataType, "false", indexSize, weakReference);
            }
        }
        if (types != null) {
            out.write("\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            for (DmcUncheckedObject dmcUncheckedObject : types.values()) {
                String name = dmcUncheckedObject.getSV("name");
                String isRefType = dmcUncheckedObject.getSV("isRefType");
                String isExtendedRefType = dmcUncheckedObject.getSV("isExtendedRefType");
                String isEnumType = dmcUncheckedObject.getSV("isEnumType");
                String isNameType = dmcUncheckedObject.getSV("isNameType");
                String internallyGenerated = dmcUncheckedObject.getSV("internallyGenerated");
                String originalClass = dmcUncheckedObject.getSV("originalClass");
                if (internallyGenerated == null) {
                    if (isNameType == null) {
                        out.write("    public final static DmcTypeInfo __type_" + name + " = new DmcTypeInfo(\"" + name + "\", OriginalTypeEnum.TYPE);\n");
                        continue;
                    }
                    out.write("    public final static DmcTypeInfo __type_" + name + " = new DmcTypeInfo(\"" + name + "\", OriginalTypeEnum.NAMETYPE);\n");
                    continue;
                }
                if (isEnumType != null) {
                    out.write("    public final static DmcTypeInfo __type_" + name + " = new DmcTypeInfo(\"" + name + "\", OriginalTypeEnum.ENUM);\n");
                    continue;
                }
                if (isRefType != null) {
                    out.write("    public final static DmcTypeInfo __type_" + originalClass + " = new DmcTypeInfo(\"" + originalClass + "\", OriginalTypeEnum.REFERENCE);\n");
                    continue;
                }
                if (isExtendedRefType != null) {
                    out.write("    public final static DmcTypeInfo __type_" + name + " = new DmcTypeInfo(\"" + name + "\", OriginalTypeEnum.EXTREF);\n");
                    continue;
                }
                out.write("    public final static DmcTypeInfo __type_" + name + " = new DmcTypeInfo(\"" + name + "\", OriginalTypeEnum.COMPLEXTYPE);\n");
            }
        }
        if (classes != null) {
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            TreeMap<String, ClassNode> treeMap = this.getHierarchyMETA(classes.values().iterator());
            out.write("\n");
            for (Object cn : treeMap.values()) {
                ((ClassNode)cn).writeClassInfo(out);
            }
        }
        if (rules != null) {
            out.write("\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            for (DmcUncheckedObject dmcUncheckedObject : rules) {
                String dataName = dmcUncheckedObject.getConstructionClass();
                int dataPos = dataName.indexOf("Data");
                String ruleClass = dataName.substring(0, dataPos);
                Iterator<String> ruleName = dmcUncheckedObject.getSV("ruleName");
                out.write("    public final static " + ruleClass + " " + (String)((Object)ruleName) + ";\n");
            }
        }
        this.writeCommonPart1(out);
        if (attributes != null) {
            for (DmcUncheckedObject dmcUncheckedObject : attributes.values()) {
                n = dmcUncheckedObject.getSV("name");
                out.write("        _SmAp.put(__" + n + ".id,__" + n + ");\n");
            }
        }
        if (classes != null) {
            for (DmcUncheckedObject dmcUncheckedObject : classes.values()) {
                n = dmcUncheckedObject.getSV("name");
                out.write("        _CmAp.put(__" + n + ".id,__" + n + ");\n");
            }
            for (DmcUncheckedObject dmcUncheckedObject : classes.values()) {
                Object cn;
                out.write("\n");
                cn = dmcUncheckedObject.getSV("name");
                TreeSet<String> must = new TreeSet<String>();
                TreeSet<String> may = new TreeSet<String>();
                this.getAllMustAndMay(dmcUncheckedObject, must, may, classes);
                for (String an : must) {
                    out.write("        __" + (String)cn + ".addMust(__" + an + ");\n");
                }
                for (String an : may) {
                    out.write("        __" + (String)cn + ".addMay(__" + an + ");\n");
                }
            }
        }
        if (rules != null && rules.size() > 0) {
            out.write("\n");
            PrintfFormat printfFormat = new PrintfFormat("%-28s");
            out.write("        try{\n");
            for (DmcUncheckedObject ruleData : rules) {
                String dataName = ruleData.getConstructionClass();
                int dataPos = dataName.indexOf("Data");
                String ruleClass = dataName.substring(0, dataPos);
                String ruleName = ruleData.getSV("ruleName");
                out.write("            " + dataName + "DMO _" + ruleName + "Data = new " + dataName + "DMO();\n");
                this.setAttributeValuesMETA(out, ruleData, printfFormat, types, attributes);
                out.write("            " + ruleClass + " " + ruleName + " = new " + ruleClass + "(_" + ruleName + "Data);\n\n");
            }
            out.write("        } catch(DmcValueException ex){\n");
            out.write("            throw(new IllegalStateException(ex));\n");
            out.write("        }\n");
        }
        out.write("\n");
        out.write(nameBuilders.toString());
        out.write(filterBuilders.toString());
        this.writeCommonPart2(out, schemaName);
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    public void getAllMustAndMay(DmcUncheckedObject uco, TreeSet<String> must, TreeSet<String> may, TreeMap<String, DmcUncheckedObject> classDefs) throws ResultException {
        NamedStringArray mayAttr;
        NamedStringArray mustAttr;
        String derivedFrom = uco.getSV("derivedFrom");
        if (derivedFrom != null) {
            DmcUncheckedObject base = classDefs.get(derivedFrom);
            this.getAllMustAndMay(base, must, may, classDefs);
        }
        if ((mustAttr = uco.get("must")) != null) {
            for (String name : mustAttr) {
                must.add(name);
            }
        }
        if ((mayAttr = uco.get("may")) != null) {
            for (String name : mayAttr) {
                may.add(name);
            }
        }
    }

    void writeCommonPart1(BufferedWriter out) throws IOException {
        out.write("\n");
        out.write("    static  HashMap<Integer, DmcClassInfo> _CmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<Integer, DmcAttributeInfo> _SmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String, DmcNameBuilderIF> _NmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String, DmcFilterBuilderIF> _FmAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String, DmcSliceInfo> _SImAp;\n");
        out.write("\n");
        out.write("    static  HashMap<String, DmcTypeInfo> _TImAp;\n");
        out.write("\n");
        out.write("    static  ArrayList<RuleIF>             _RmAp;\n");
        out.write("\n");
        out.write("    static {\n");
        out.write("        _CmAp = new HashMap<Integer, DmcClassInfo>();\n");
        out.write("\n");
        out.write("        _SmAp = new HashMap<Integer, DmcAttributeInfo>();\n");
        out.write("\n");
        out.write("        _NmAp = new HashMap<String, DmcNameBuilderIF>();\n");
        out.write("\n");
        out.write("        _FmAp = new HashMap<String, DmcFilterBuilderIF>();\n");
        out.write("\n");
        out.write("        _SImAp = new HashMap<String, DmcSliceInfo>();\n");
        out.write("\n");
        out.write("        _TImAp = new HashMap<String, DmcTypeInfo>();\n");
        out.write("\n");
        out.write("        _RmAp = new ArrayList<RuleIF>();\n");
        out.write("\n");
    }

    void writeCommonPart2(BufferedWriter out, String schemaName) throws IOException {
        out.write("\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    static  " + schemaName + " instance;\n");
        out.write("\n");
        out.write("    protected " + schemaName + " (){\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public synchronized static " + schemaName + " instance(){\n");
        out.write("        if (instance == null)\n");
        out.write("            instance = new " + schemaName + "();\n");
        out.write("        \n");
        out.write("        return(instance);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public DmcClassInfo getClassInfo(Integer id){\n");
        out.write("        return(_CmAp.get(id));\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public DmcAttributeInfo getAttributeInfo(Integer id){\n");
        out.write("        return(_SmAp.get(id));\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcAttributeInfo> getAttributeInfo(){\n");
        out.write("        return(_SmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcClassInfo> getClassInfo(){\n");
        out.write("        return(_CmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcNameBuilderIF> getNameBuilders(){\n");
        out.write("        return(_NmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcFilterBuilderIF> getFilterBuilders(){\n");
        out.write("        return(_FmAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcSliceInfo> getSliceInfo(){\n");
        out.write("        return(_SImAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<DmcTypeInfo> getTypeInfo(){\n");
        out.write("        return(_TImAp.values().iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public String getSchemaName(){\n");
        out.write("        return(schemaName);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public int getSchemaBaseID(){\n");
        out.write("        return(schemaBaseID);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public int getSchemaIDRange(){\n");
        out.write("        return(schemaIDRange);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public int getSchemaMaxID(){\n");
        out.write("        return(schemaMaxID);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
        out.write("    public Iterator<RuleIF> getRules(){\n");
        out.write("        return(_RmAp.iterator());\n");
        out.write("    }\n");
        out.write("\n");
        out.write("\n");
    }

    void dumpHeaderMETA(BufferedWriter out, String schemaPackage) throws IOException {
        out.write("package " + schemaPackage + ".generated.dmo;\n\n");
        out.write("import java.util.HashMap;\n");
        out.write("import java.util.ArrayList;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import org.dmd.dmc.*;\n");
        out.write("import org.dmd.dms.generated.enums.ClassTypeEnum;\n");
        out.write("import org.dmd.dms.generated.enums.ValueTypeEnum;\n");
        out.write("import org.dmd.dms.generated.enums.DataTypeEnum;\n");
        out.write("import org.dmd.dms.generated.enums.OriginalTypeEnum;\n");
        out.write("import org.dmd.dms.generated.types.*;\n");
        out.write("import org.dmd.dmc.rules.RuleIF;\n");
        out.write("\n");
    }

    void dumpHeaderDMSAG(BufferedWriter out, SchemaManager sm, String schemaPackage, SchemaDefinition sd, StringBuffer nameBuilders, StringBuffer filterBuilders) throws IOException, ResultException, DmcNameClashException, DmcValueException {
        out.write("package " + schemaPackage + ".generated.dmo;\n\n");
        ImportManager manager = new ImportManager();
        manager.addImport("java.util.HashMap", "For storage of schema info");
        manager.addImport("java.util.ArrayList", "For storage of schema info");
        manager.addImport("java.util.Iterator", "For access of schema info");
        manager.addImport("org.dmd.dmc.*", "Basic DMC stuff");
        manager.addImport("org.dmd.dmc.rules.RuleIF", "For rule info");
        DmcAttribute<?> cdef = sd.getDMO().get(MetaDMSAG.__classDefList);
        if (cdef != null) {
            manager.addImport("org.dmd.dms.generated.enums.ClassTypeEnum", "Have class definitions");
            manager.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "Have class/attribute definitions");
        }
        if (sd.getTypeDefListSize() > 0 || sd.getInternalTypeDefListSize() > 0) {
            manager.addImport("org.dmd.dms.generated.enums.OriginalTypeEnum", "Have type/internal type definitions");
        }
        for (Object cd : sd.getClassDefList()) {
            if (((ClassDefinitionDMW)cd).getDerivedFrom() != null && ((ClassDefinitionDMW)cd).getDerivedFrom().getDefinedIn() != sd) {
                manager.addImport(((SchemaDefinition)((ClassDefinitionDMW)cd).getDerivedFrom().getDefinedIn()).getDMSASGImport(), "Base class from " + ((SchemaDefinition)((ClassDefinitionDMW)cd).getDerivedFrom().getDefinedIn()).getDMSASGName());
            }
            if (((ClassDefinitionDMW)cd).getIsNamedBy() == null || ((ClassDefinitionDMW)cd).getIsNamedBy().getDefinedIn() == sd) continue;
            manager.addImport(((SchemaDefinition)((ClassDefinitionDMW)cd).getIsNamedBy().getDefinedIn()).getDMSASGImport(), "Naming attribute from " + ((SchemaDefinition)((ClassDefinitionDMW)cd).getIsNamedBy().getDefinedIn()).getDMSASGName());
        }
        DmcAttribute<?> adef = sd.getDMO().get(MetaDMSAG.__attributeDefList);
        if (adef != null) {
            manager.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "Have class/attribute definitions");
            manager.addImport("org.dmd.dms.generated.enums.ValueTypeEnum", "Have attribute definitions");
        }
        for (RuleDefinition rd : sd.getRuleDefinitionList()) {
            manager.addImport(rd.getRuleDefinitionImport(), "To support instantiations of " + rd.getName());
        }
        Iterator<DmcUncheckedObject> rules = sd.getParsedRules();
        if (rules != null) {
            while (rules.hasNext()) {
                DmcUncheckedObject rule = rules.next();
                ClassDefinition ruleDataCD = sm.isClass(rule.getConstructionClass());
                if (ruleDataCD == null) {
                    ResultException ex = new ResultException();
                    ex.addError("Unknown rule data class. For Rule instance: \n" + rule.toOIF());
                    throw ex;
                }
                manager.addImport(ruleDataCD.getDmoImport(), "To instantiate " + rule.getConstructionClass() + " rule data");
                manager.addImport(ruleDataCD.getRuleDefinition().getRuleDefinitionImport(), "To instantiate rules of this type");
                ruleDataCD.addImportsForAdditionalAttributes(sm, manager, rule);
            }
        }
        out.write(manager.getFormattedImports());
        out.write("\n");
        TypeDefinitionIterableDMW tds = sd.getTypeDefList();
        if (tds != null) {
            while (tds.hasNext()) {
                String adn;
                TypeDefinition td = (TypeDefinition)tds.next();
                if (td.getIsNameType().booleanValue()) {
                    if (td.getNameAttributeDef() == null) {
                        throw new IllegalStateException("TypeDefinition " + td.getName() + "  does not have a designated naming attribute.");
                    }
                    adn = td.getName().getNameString();
                    nameBuilders.append("        _NmAp.put(DmcType" + adn + "STATIC.instance.getNameClass(),DmcType" + adn + "STATIC.instance);\n");
                    continue;
                }
                if (!td.getIsFilterType().booleanValue()) continue;
                if (td.getFilterAttributeDef() == null) {
                    throw new IllegalStateException("TypeDefinition " + td.getName() + "  does not have a designated filter attribute.");
                }
                adn = td.getName().getNameString();
                nameBuilders.append("        _FmAp.put(DmcType" + adn + "STATIC.instance.getFilterClass(),DmcType" + adn + "STATIC.instance);\n");
            }
        }
        if (nameBuilders.length() > 0) {
            out.write("import " + schemaPackage + ".generated.types.*;\n");
        }
        out.write("\n");
    }

    void writeAttributeInfoMETA(BufferedWriter out, String n, String ID, String t, String mv, String dataType, String opt, String is, String wr) throws IOException {
        out.write("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.write("\"meta\",");
        out.write("\"" + n + "\",");
        out.write(ID + ",");
        out.write("\"" + t + "\",");
        if (mv == null) {
            out.write("ValueTypeEnum.SINGLE,");
        } else {
            out.write("ValueTypeEnum.MULTI,");
        }
        out.write("DataTypeEnum." + dataType);
        out.write("," + is);
        out.write("," + wr);
        out.write(");\n");
    }

    TreeMap<String, ClassNode> getHierarchyMETA(Iterator<DmcUncheckedObject> classes) throws ResultException {
        TreeMap<String, ClassNode> sorted = new TreeMap<String, ClassNode>();
        TreeMap<String, ClassNode> hierarchy = new TreeMap<String, ClassNode>();
        while (classes.hasNext()) {
            DmcUncheckedObject uco = classes.next();
            String name = uco.getSV("name");
            sorted.put(name, new ClassNode(name, uco));
        }
        for (ClassNode cn : sorted.values()) {
            String derivedFrom = cn.uco.getSV("derivedFrom");
            if (derivedFrom == null) {
                hierarchy.put(cn.name, cn);
                continue;
            }
            ClassNode parent = (ClassNode)sorted.get(derivedFrom);
            parent.addDerived(cn);
        }
        return hierarchy;
    }

    TreeMap<String, ClassNode> getHierarchy(Iterator<ClassDefinition> classes) {
        TreeMap<String, ClassNode> sorted = new TreeMap<String, ClassNode>();
        TreeMap<String, ClassNode> hierarchy = new TreeMap<String, ClassNode>();
        while (classes.hasNext()) {
            ClassDefinition cd = classes.next();
            String name = cd.getName().getNameString();
            sorted.put(name, new ClassNode(name, cd));
        }
        for (ClassNode cn : sorted.values()) {
            ClassDefinition cd = cn.cd;
            ClassDefinition derivedFrom = cd.getDerivedFrom();
            if (derivedFrom == null) {
                hierarchy.put(cn.name, cn);
                continue;
            }
            ClassNode parent = (ClassNode)sorted.get(derivedFrom.getName().getNameString());
            if (parent == null) {
                String temp = ((SchemaDefinitionDMW)cd.getDerivedFrom().getDefinedIn()).getName().getNameString();
                String name = GeneratorUtils.dotNameToCamelCase(temp) + "DMSAG";
                cn.parentRef = name + ".__" + cd.getDerivedFrom().getName();
                hierarchy.put(cn.name, cn);
                continue;
            }
            parent.addDerived(cn);
        }
        return hierarchy;
    }

    private void setAttributeValuesMETA(BufferedWriter out, DmcUncheckedObject obj, PrintfFormat pf, TreeMap<String, DmcUncheckedObject> typeDefs, TreeMap<String, DmcUncheckedObject> attributeDefs) throws IOException, ResultException {
        String attrName = null;
        String objName = null;
        DmcUncheckedObject attrDef = null;
        String typeName = null;
        DmcUncheckedObject typeDef = null;
        boolean multiValued = false;
        boolean isReference = false;
        boolean isEnumType = false;
        objName = obj.getSV("ruleName") + "Data";
        Iterator<String> attributeNames = obj.getAttributeNames();
        while (attributeNames.hasNext()) {
            String val;
            NamedStringArray attr = obj.get(attributeNames.next());
            attrName = attr.getName();
            if (attrName == null) {
                DebugInfo.debug("Attr name null");
                continue;
            }
            attrDef = attributeDefs.get(attrName);
            multiValued = false;
            isReference = false;
            isEnumType = false;
            if (attrDef == null) {
                ResultException ex = new ResultException();
                ex.addError("Unknown attribute: " + attrName);
                ex.result.lastResult().fileName("metaSchema.dms");
                ex.result.lastResult().lineNumber(obj.lineNumber);
                throw ex;
            }
            if (!(!obj.getConstructionClass().equals("InitRuleData") || attrName.equals("ruleName") || attrName.equals("ruleTitle") || attrName.equals("description") || attrName.equals("applyToClass"))) {
                this.formatOtherAttribute(out, pf, typeDefs, attrDef);
                continue;
            }
            if (attrDef.getSV("valueType") != null) {
                multiValued = true;
            }
            if ((typeDef = typeDefs.get(typeName = attrDef.getSV("type"))) == null) {
                typeDef = typeDefs.get(typeName + "REF");
                isReference = true;
                if (typeDef.getSV("isEnumType") != null) {
                    isEnumType = true;
                }
            }
            StringBuffer attrNameCapped = new StringBuffer();
            attrNameCapped.append(attrName);
            attrNameCapped.setCharAt(0, Character.toUpperCase(attrNameCapped.charAt(0)));
            if (attrName.equals("type")) {
                isReference = false;
                isEnumType = false;
                typeName = obj.getSV("type");
                typeDef = typeDefs.get(typeName);
                if (typeDef == null) {
                    typeDef = typeDefs.get(typeName + "REF");
                    isReference = true;
                    if (typeDef.getSV("isEnumType") != null) {
                        isEnumType = true;
                    }
                }
                out.write("            _" + pf.sprintf(objName));
                out.write(".setType(");
                if (isReference) {
                    out.write("_" + obj.getSV(attrName) + "REF);\n");
                    continue;
                }
                out.write("_" + obj.getSV(attrName) + ");\n");
                continue;
            }
            if (multiValued) {
                for (String attrVal : attr) {
                    out.write("            _" + pf.sprintf(objName));
                    out.write(".add" + attrNameCapped + "(");
                    if (isReference) {
                        if (isEnumType) {
                            out.write(typeName + "." + attrVal + ");\n");
                            continue;
                        }
                        out.write("_" + attrVal + ");\n");
                        continue;
                    }
                    out.write("\"" + attrVal + "\");\n");
                }
                continue;
            }
            out.write("            _" + pf.sprintf(objName));
            out.write(".set" + attrNameCapped + "(");
            if (isReference) {
                if (isEnumType) {
                    out.write(typeName + "." + obj.getSV(attrName) + ");\n");
                    continue;
                }
                out.write("_" + obj.getSV(attrName) + ");\n");
                continue;
            }
            String value = obj.getSV(attrName);
            if (attrName.equals("name") && (val = obj.getSV(attrName)).endsWith("EnumREF")) {
                value = val.replaceFirst("REF", "");
            }
            out.write("\"" + value + "\");\n");
        }
        out.write("\n");
    }

    private void formatOtherAttribute(BufferedWriter out, PrintfFormat pf, TreeMap<String, DmcUncheckedObject> typeDefs, DmcUncheckedObject attribute) throws IOException, ResultException {
        String typeName = attribute.getSV("type");
        DmcUncheckedObject type = typeDefs.get(typeName);
        DebugInfo.debug(type.toOIF() + "\n");
    }

    class ClassNode {
        String name;
        ClassDefinition cd;
        DmcUncheckedObject uco;
        TreeMap<String, ClassNode> derived;
        String parentRef;

        ClassNode(String n, ClassDefinition def) {
            this.name = n;
            this.cd = def;
            this.derived = new TreeMap();
        }

        ClassNode(String n, DmcUncheckedObject def) {
            this.name = n;
            this.uco = def;
            this.derived = new TreeMap();
        }

        void addDerived(ClassNode cn) {
            this.derived.put(cn.name, cn);
        }

        void writeClassInfo(BufferedWriter out) throws IOException {
            if (this.cd == null) {
                String ID = this.uco.getSV("dmdID");
                String ct = this.uco.getSV("classType");
                String derivedFrom = this.uco.getSV("derivedFrom");
                String isNamedBy = this.uco.getSV("isNamedBy");
                String dmoImport = this.uco.getSV("dmoImport");
                out.write("    public final static DmcClassInfo __" + this.name + " = new DmcClassInfo(");
                out.write("\"" + this.name + "\",");
                out.write("\"" + dmoImport + "\",");
                out.write(ID + ",");
                out.write("ClassTypeEnum." + ct + ",");
                out.write("DataTypeEnum.PERSISTENT");
                if (derivedFrom == null) {
                    out.write(",null");
                } else {
                    out.write(",__" + derivedFrom);
                }
                if (isNamedBy == null) {
                    out.write(",null");
                } else {
                    out.write(",MetaDMSAG.__" + isNamedBy);
                }
                out.write(");\n");
            } else {
                out.write("    public final static DmcClassInfo __" + this.cd.getName().getNameString() + " = new DmcClassInfo(");
                out.write("\"" + this.cd.getName().getNameString() + "\"");
                out.write(",\"" + this.cd.getDmoImport() + "\"");
                out.write(", " + this.cd.getDmdID());
                out.write(", ClassTypeEnum." + (Object)((Object)this.cd.getClassType()));
                out.write(", DataTypeEnum." + (Object)((Object)this.cd.getDataType()));
                if (this.cd.getDerivedFrom() == null) {
                    out.write(",null");
                } else if (this.parentRef == null) {
                    out.write(",__" + this.cd.getDerivedFrom().getName());
                } else {
                    out.write("," + this.parentRef);
                }
                if (this.cd.getIsNamedBy() == null) {
                    out.write(",null");
                } else {
                    AttributeDefinition ad = this.cd.getIsNamedBy();
                    String schema = ((SchemaDefinition)ad.getDefinedIn()).getDMSASGName();
                    out.write("," + schema + ".__" + ad.getName());
                }
                out.write(");\n");
            }
            for (ClassNode cn : this.derived.values()) {
                cn.writeClassInfo(out);
            }
        }
    }
}

