/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ClassDefinitionREF;

public class DmoDeserializer {
    SchemaManager schema;

    public DmoDeserializer(SchemaManager s) {
        this.schema = s;
    }

    public SchemaManager getSchema() {
        return this.schema;
    }

    public DmcObject deserialize(DmcInputStreamIF dis) throws Exception {
        DmcObject dmo = null;
        int classCount = dis.readInt();
        int classID = dis.readInt();
        ClassDefinition cd = this.schema.isClass(classID);
        if (cd == null) {
            throw new IllegalStateException("Unknown class ID: " + classID + " ensure that you have loaded the required schemas.");
        }
        dmo = cd.newDMOInstance();
        if (classCount > 1) {
            for (int i = 1; i < classCount; ++i) {
                classID = dis.readInt();
                cd = this.schema.isClass(classID);
                dmo.addAux(new ClassDefinitionREF(cd.getDMO()));
            }
        }
        int attrCount = dis.readAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            DmcAttribute<?> attr = dis.getAttributeInstance();
            attr.deserializeIt(dis);
            if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                dmo.set(attr.getAttributeInfo(), attr);
                continue;
            }
            dmo.add(attr.getAttributeInfo(), attr);
        }
        return dmo;
    }
}

