/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.generated.dmw.EnumDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.types.EnumValue;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.CodeFormatter;

public class DmoEnumFormatter {
    String fileHeader;
    PrintStream progress;

    public DmoEnumFormatter() {
        this.progress = null;
    }

    public DmoEnumFormatter(PrintStream o) {
        this.progress = o;
    }

    public void setFileHeader(String fh) {
        this.fileHeader = fh;
    }

    public void dumpEnums(SchemaDefinition sd, String outdir) throws IOException {
        EnumDefinitionIterableDMW enums = sd.getEnumDefList();
        if (enums != null) {
            while (enums.hasNext()) {
                this.dumpEnum((EnumDefinition)enums.next(), outdir);
            }
        }
    }

    private void dumpEnum(EnumDefinition ed, String outdir) throws IOException {
        String cn = ed.getName().getNameString();
        String schemaPackage = ((SchemaDefinitionDMW)ed.getDefinedIn()).getSchemaPackage();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, cn + ".java");
        if (this.fileHeader != null) {
            out.write(this.fileHeader);
        }
        out.write("package " + schemaPackage + ".generated.enums;\n\n");
        out.write("import java.util.*;\n\n");
        out.write("import org.dmd.dmc.DmcEnumIF;\n\n");
        out.write("/**\n");
        CodeFormatter.dumpCodeComment(ed.getDescription(), (BufferedWriter)out, " * ");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + ((SchemaDefinitionDMW)ed.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)ed.getDefinedIn()).getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmogenerator utility and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public enum " + cn + " implements DmcEnumIF\n{\n");
        Iterator<EnumValue> enumit = ed.getEnumValue();
        while (enumit.hasNext()) {
            EnumValue ev = enumit.next();
            out.write("    " + ev.getName() + "(" + ev.getId() + ",\"" + ev.getDescription() + "\")");
            if (enumit.hasNext()) {
                out.write(",\n\n");
                continue;
            }
            out.write(";\n\n");
        }
        out.write("    // Maps our integer value to the enumeration value\n");
        out.write("    private static final Map<Integer," + cn + "> lookup = new HashMap<Integer," + cn + ">();\n\n");
        out.write("    static {\n");
        out.write("        for(" + cn + " s : EnumSet.allOf(" + cn + ".class))\n");
        out.write("            lookup.put(s.intValue(), s);\n");
        out.write("    }\n\n");
        out.write("    // Maps our enumeration (string) value to the enumeration value\n");
        out.write("    private static final Map<String," + cn + "> lookupString = new HashMap<String, " + cn + ">();\n\n");
        out.write("    static {\n");
        out.write("        for(" + cn + " s : EnumSet.allOf(" + cn + ".class))\n");
        out.write("            lookupString.put(s.name(), s);\n");
        out.write("    }\n\n");
        out.write("    // Our current value as an int - normally, this isn't available in an enum\n");
        out.write("    private int ival;\n\n");
        out.write("    // Our current display value as a String\n");
        out.write("    private String dval;\n\n");
        out.write("    /**\n");
        out.write("     * This private constructor allows us to access our int value when required.\n");
        out.write("     */\n");
        out.write("    private " + cn + "(int i, String d){\n");
        out.write("        ival = i;\n");
        out.write("        dval = d;\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Returns the value of this enum value as an int.\n");
        out.write("     */\n");
        out.write("    public int intValue(){\n");
        out.write("        return(ival);\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Returns the display value of this enum value as a String.\n");
        out.write("     */\n");
        out.write("    public String displayValue(){\n");
        out.write("        return(dval);\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Returns the enum value of the specified int or null if it's not valid.\n");
        out.write("     */\n");
        out.write("    public static " + cn + " get(int code) {\n");
        out.write("        return(lookup.get(code));\n");
        out.write("    }\n\n");
        out.write("    /**\n");
        out.write("     * Returns a value for this enum or throws an exception if the String value isn't\n");
        out.write("     * a valid member of this enum.\n");
        out.write("     */\n");
        out.write("    public static " + cn + " get(String str) {\n");
        out.write("        return(lookupString.get(str.toUpperCase()));\n");
        out.write("    }\n\n");
        out.write("}");
        ((BufferedWriter)out).close();
    }
}

