/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.ActionDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.CodeFormatter;

public class DmoFormatter {
    String fileHeader;
    SchemaManager schema;
    ArrayList<AttributeDefinition> allAttr;
    PrintStream progress;

    public DmoFormatter() {
        this.progress = null;
    }

    public DmoFormatter(PrintStream o) {
        this.progress = o;
    }

    public void setFileHeader(String fh) {
        this.fileHeader = fh;
    }

    public void dumpDMOs(SchemaManager sm, SchemaDefinition sd, String dmodir, String auxdir) throws IOException, ResultException {
        this.schema = sm;
        ClassDefinitionIterableDMW cdl = sd.getClassDefList();
        if (cdl != null) {
            while (cdl.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdl.next();
                if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                    this.dumpAUX(cd, auxdir);
                    continue;
                }
                this.dumpDMO(cd, dmodir);
            }
        }
    }

    private void dumpDMO(ClassDefinition cd, String outdir) throws IOException, ResultException {
        this.allAttr = new ArrayList();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, cd.getName().getNameString() + "DMO.java");
        if (this.fileHeader != null) {
            out.write(this.fileHeader);
        }
        out.write("package " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.dmo;\n\n");
        BooleanVar anyMVAttributes = new BooleanVar(false);
        BooleanVar anySVAttributes = new BooleanVar(false);
        out.write(this.getImports(cd, anySVAttributes, anyMVAttributes));
        out.write(this.getClassHeader(cd, DebugInfo.getWhereWeAreNow()));
        out.write(" {\n\n");
        out.write("    public final static String constructionClassName = \"" + cd.getName().getNameString() + "\";\n\n");
        StringBuffer staticInit = new StringBuffer();
        out.write("\n");
        out.write("    static {\n");
        out.write(staticInit.toString());
        out.write("    }\n\n");
        out.write("    public " + cd.getName() + "DMO() {\n");
        out.write("        super(\"" + cd.getName() + "\");\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    protected " + cd.getName() + "DMO(String oc) {\n");
        out.write("        super(oc);\n");
        out.write("    }\n");
        out.write("\n");
        if (!cd.getSupportsBackrefTracking().booleanValue()) {
            out.write("    @Override\n");
            out.write("    public boolean supportsBackrefTracking(){\n");
            out.write("        return(false);\n");
            out.write("    }\n\n");
        }
        if (cd.getClassType() != ClassTypeEnum.ABSTRACT) {
            out.write("    @Override\n");
            out.write("    public " + cd.getName() + "DMO getNew(){\n");
            out.write("        " + cd.getName() + "DMO rc = new " + cd.getName() + "DMO();\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("    @Override\n");
            out.write("    public " + cd.getName() + "DMO getSlice(DmcSliceInfo info){\n");
            out.write("        " + cd.getName() + "DMO rc = new " + cd.getName() + "DMO();\n");
            out.write("        populateSlice(rc,info);\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
            out.write("    public " + cd.getName() + "DMO(DmcTypeModifierMV mods) {\n");
            out.write("        super(\"" + cd.getName() + "\");\n");
            out.write("        modrec(true);\n");
            out.write("        setModifier(mods);\n");
            out.write("    }\n");
            out.write("\n");
            if (cd.getIsNamedBy() == null) {
                out.write("    public " + cd.getName() + "DMO getModificationRecorder(){\n");
                out.write("        " + cd.getName() + "DMO rc = new " + cd.getName() + "DMO();\n");
                out.write("        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                out.write("        rc.modrec(true);\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
            } else {
                String upper = Manipulator.capFirstChar(cd.getIsNamedBy().getObjectName().toString());
                out.write("    public " + cd.getName() + "DMO getModificationRecorder(){\n");
                out.write("        " + cd.getName() + "DMO rc = new " + cd.getName() + "DMO();\n");
                out.write("        rc.set" + upper + "(get" + upper + "());\n");
                out.write("        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                out.write("        rc.modrec(true);\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
            }
        }
        out.write(this.getAccessFunctions(cd));
        out.write("\n");
        out.write(this.getATIFunctions(cd));
        out.write("\n\n}\n");
        ((BufferedWriter)out).close();
    }

    void appendAttributeInfo(StringBuffer out, String n, int ID, String t, ValueTypeEnum vte, DataTypeEnum dte, String opt) {
        out.append("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.append("\"" + n + "\",");
        out.append(ID + ",");
        out.append("\"" + t + "\",");
        out.append("ValueTypeEnum." + vte.toString() + ",");
        out.append("DataTypeEnum." + dte.toString());
        out.append(");\n");
    }

    String getATIFunctions(ClassDefinition cd) {
        StringBuffer sb = new StringBuffer();
        ActionDefinitionIterableDMW actions = cd.getActions();
        if (actions != null) {
            while (actions.hasNext()) {
                ActionDefinition ad = (ActionDefinition)actions.next();
                String capped = Manipulator.capFirstChar(ad.getName().getNameString());
                sb.append("\n");
                sb.append("    /**\n");
                sb.append("     * Returns the parameter container for the " + ad.getName() + " action.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    static public " + capped + "ATI get" + capped + "ATI(){\n");
                sb.append("        return(new " + capped + "ATI());\n");
                sb.append("    }\n");
            }
        }
        return sb.toString();
    }

    private void dumpAUX(ClassDefinition cd, String outdir) throws IOException, ResultException {
        this.allAttr = new ArrayList();
        BooleanVar anyMVAttributes = new BooleanVar(false);
        BooleanVar anySVAttributes = new BooleanVar(false);
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, cd.getName().getNameString() + "DMO.java");
        if (this.fileHeader != null) {
            out.write(this.fileHeader);
        }
        out.write("package " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.dmo;\n\n");
        out.write(this.getImports(cd, anySVAttributes, anyMVAttributes));
        out.write(this.getClassHeader(cd, DebugInfo.getWhereWeAreNow()));
        out.write(" {\n\n");
        out.write("    public final static String _auxClass = \"" + cd.getName() + "\";\n");
        StringBuffer staticInit = new StringBuffer();
        out.write("\n");
        out.write("    static {\n");
        out.write(staticInit.toString());
        out.write("    }\n");
        out.write(this.getCommonAUXFunctions(anySVAttributes.booleanValue(), anyMVAttributes.booleanValue()));
        out.write(this.getAUXAccessFunctions(cd));
        out.write("\n");
        out.write("\n\n}\n");
        ((BufferedWriter)out).close();
    }

    String getCommonAUXFunctions(boolean anySVAttributes, boolean anyMVAttributes) {
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n");
        sb.append("     * This method will check to see if the object has any of our attributes.\n");
        sb.append("     * If not, our aux class is automatically removed from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static private void removeAuxIfRequired(DmcObject core){\n");
        sb.append("        boolean anyLeft = false;\n");
        sb.append("\n");
        for (AttributeDefinition ad : this.allAttr) {
            sb.append("        if (core.get(" + ad.getDMSAGReference() + ") != null)\n");
            sb.append("            anyLeft = true;\n");
        }
        sb.append("\n");
        sb.append("        if (!anyLeft)\n");
        sb.append("            core.removeAux(_auxClass);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     * This method will check to see if the object has our aux class.\n");
        sb.append("     * If not, we add our aux class the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static private void addAuxIfRequired(DmcObject core) throws DmcValueException {\n");
        sb.append("        if (!core.hasAux(_auxClass))\n");
        sb.append("            core.addAux(_auxClass);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     * Determines if the specified class is in our ocl.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public boolean hasAux(DmcObject core) throws DmcValueException {\n");
        sb.append("        if (core == null)\n");
        sb.append("            return(false);\n");
        sb.append("        return(core.hasAux(_auxClass));\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static private DmcAttribute<?> get(DmcObject core, DmcAttributeInfo ai){\n");
        sb.append("        if (core == null)\n");
        sb.append("            return(null);\n");
        sb.append("        return(core.get(ai));\n");
        sb.append("    }\n");
        sb.append("\n");
        if (anySVAttributes) {
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static private DmcAttribute<?> set(DmcObject core, DmcAttributeInfo ai, DmcAttribute<?> attr) throws DmcValueException {\n");
            sb.append("        if (core == null)\n");
            sb.append("            return(null);\n");
            sb.append("        addAuxIfRequired(core);\n");
            sb.append("        return(core.set(ai,attr));\n");
            sb.append("    }\n");
            sb.append("\n");
        }
        if (anyMVAttributes) {
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static private DmcAttribute<?> add(DmcObject core, DmcAttributeInfo ai, DmcAttribute<?> attr) throws DmcValueException {\n");
            sb.append("        if (core == null)\n");
            sb.append("            return(null);\n");
            sb.append("        addAuxIfRequired(core);\n");
            sb.append("        return(core.add(ai,attr));\n");
            sb.append("    }\n");
            sb.append("\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static private DmcAttribute<?> del(DmcObject core, DmcAttributeInfo ai, Object value) throws DmcValueException {\n");
            sb.append("        if (core == null)\n");
            sb.append("            return(null);\n");
            sb.append("        DmcAttribute<?> rc = core.del(ai,value);\n");
            sb.append("        removeAuxIfRequired(core);\n");
            sb.append("        return(rc);\n");
            sb.append("    }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    String getImports(ClassDefinition cd, BooleanVar anySVAttributes, BooleanVar anyMVAttributes) throws ResultException {
        AttributeDefinitionIterableDMW may = cd.getMay();
        AttributeDefinitionIterableDMW must = cd.getMust();
        return GenUtility.getImports(cd, may, must, this.allAttr, anySVAttributes, anyMVAttributes);
    }

    String getClassHeader(ClassDefinition cd, String where) {
        StringBuffer sb = new StringBuffer();
        sb.append("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("/**\n");
        CodeFormatter.dumpCodeComment(cd.getDescription(), sb, " * ");
        sb.append(" * <P>\n");
        sb.append(" * Generated from the " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)cd.getDefinedIn()).getVersion() + "\n");
        sb.append(" * <P>\n");
        sb.append(" * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!\n");
        sb.append(" * Generated from: " + where + "\n");
        sb.append(" */\n");
        if (cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            sb.append("@SuppressWarnings(\"serial\")\n");
        }
        switch (cd.getClassType()) {
            case ABSTRACT: {
                sb.append("abstract public class ");
                break;
            }
            case AUXILIARY: 
            case EXTENSIBLE: 
            case STRUCTURAL: {
                sb.append("public class ");
                break;
            }
            case INTERFACE: {
                break;
            }
        }
        sb.append(cd.getName() + "DMO ");
        if (cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            if (cd.getDerivedFrom() == null) {
                sb.append(" extends DmcObject ");
            } else {
                sb.append(" extends " + cd.getDerivedFrom().getName() + "DMO ");
            }
            if (cd.getIsNamedBy() == null) {
                if (cd.getUsesInterface() == null) {
                    sb.append(" implements ");
                } else {
                    sb.append(" implements " + cd.getUsesInterface() + ", ");
                }
            } else {
                sb.append(" implements DmcNamedObjectIF");
                if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                    sb.append(", DmcHierarchicNamedObjectIF");
                }
                if (cd.getUsesInterface() == null) {
                    sb.append(", ");
                } else {
                    sb.append("," + cd.getUsesInterface() + ", ");
                }
            }
            sb.append("Serializable ");
        }
        return sb.toString();
    }

    String getAccessFunctions(ClassDefinition cd) {
        StringBuffer sb = new StringBuffer();
        if (cd.getIsNamedBy() != null) {
            String tn = cd.getIsNamedBy().getType().getName().getNameString();
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + tn + " getObjectName(){\n");
            sb.append("        DmcAttribute<?> name = get(" + cd.getIsNamedBy().getDMSAGReference() + ");\n");
            sb.append("        if (name != null)\n");
            sb.append("            return((" + tn + ")name.getSV());\n");
            sb.append("    \n");
            sb.append("        return(null);\n");
            sb.append("    }\n\n");
            if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + tn + " getHierarchicObjectName(){\n");
                sb.append("        return(getObjectName());\n");
                sb.append("    }\n\n");
            }
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public DmcAttribute<?> getObjectNameAttribute(){\n");
            sb.append("        DmcAttribute<?> name = get(" + cd.getIsNamedBy().getDMSAGReference() + ");\n");
            sb.append("        return(name);\n");
            sb.append("    }\n\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public boolean equals(Object obj){\n");
            sb.append("        if (obj instanceof " + cd.getName() + "DMO){\n");
            sb.append("            return( getObjectName().equals( ((" + cd.getName() + "DMO) obj).getObjectName()) );\n");
            sb.append("        }\n");
            sb.append("        return(false);\n");
            sb.append("    }\n\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public int hashCode(){\n");
            sb.append("        " + tn + " objn = getObjectName();\n");
            sb.append("        if (objn == null)\n");
            sb.append("            return(0);\n");
            sb.append("        \n");
            sb.append("        return(objn.hashCode());\n");
            sb.append("    }\n\n");
        }
        for (AttributeDefinition ad : this.allAttr) {
            switch (ad.getValueType()) {
                case SINGLE: {
                    GenUtility.formatSV(ad, sb);
                    break;
                }
                case MULTI: 
                case HASHSET: 
                case TREESET: {
                    GenUtility.formatMV(ad, sb);
                    break;
                }
                case HASHMAPPED: {
                    GenUtility.formatMAPPED(ad, sb);
                    break;
                }
                case TREEMAPPED: {
                    GenUtility.formatMAPPED(ad, sb);
                }
            }
        }
        return sb.toString();
    }

    String getAUXAccessFunctions(ClassDefinition cd) {
        StringBuffer sb = new StringBuffer();
        for (AttributeDefinition ad : this.allAttr) {
            switch (ad.getValueType()) {
                case SINGLE: {
                    this.formatSVAUX(ad, sb);
                    break;
                }
                case MULTI: {
                    this.formatMVAUX(ad, sb);
                    break;
                }
                case HASHSET: 
                case TREESET: 
                case HASHMAPPED: 
                case TREEMAPPED: {
                    throw new IllegalStateException("Mapped and Set attributes aren't currently supported on AUXILIARY classes. Occurred with:\n" + cd.toOIF());
                }
            }
        }
        return sb.toString();
    }

    void formatSVAUX(AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String nullReturnValue = ad.getType().getNullReturnValue();
        String typeName = ad.getType().getName().getNameString();
        if (ad.getNullReturnValue() != null) {
            nullReturnValue = ad.getNullReturnValue();
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        attrType = attrType + "SV";
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> rem" + functionName + "(DmcObject core){\n");
        sb.append("        if (core == null)\n");
        sb.append("            return(null);\n");
        sb.append("        DmcAttribute<?> rc = core.rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("        removeAuxIfRequired(core);\n");
        sb.append("        return(rc);\n");
        sb.append("    }\n");
        sb.append("\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            typeName = ad.getType().getOriginalClass().getName() + "REF";
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public " + typeName + " get" + functionName + "(DmcObject core){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            if (nullReturnValue == null) {
                sb.append("            return(null);\n");
            } else {
                sb.append("            return(" + nullReturnValue + ");\n");
            }
            sb.append("\n");
            sb.append("        return(attr.getSV());\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public " + typeName + " get" + functionName + "(DmcObject core){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            if (nullReturnValue == null) {
                sb.append("            return(null);\n");
            } else {
                sb.append("            return(" + nullReturnValue + ");\n");
            }
            sb.append("\n");
            sb.append("        return(attr.getSV());\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
        sb.append("     * @param value A value compatible with " + attrType + "\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public void set" + functionName + "(DmcObject core, Object value) throws DmcValueException {\n");
        sb.append("        DmcAttribute<?> attr = get(core, " + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        attr.set(value);\n");
        sb.append("        set(core, " + ad.getDMSAGReference() + ",attr);\n");
        sb.append("    }\n\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value A value compatible with " + attrType + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void set" + functionName + "(DmcObject core, " + ad.getType().getOriginalClass().getName() + "DMO value){\n");
            sb.append("        DmcAttribute<?> attr = get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        try {\n");
            sb.append("            attr.set(value);\n");
            sb.append("            set(core, " + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        } catch (DmcValueException e) {\n");
            sb.append("            throw(new IllegalStateException(\"Type specific modification shouldn't cause an error.\", e));\n");
            sb.append("        }\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value A value compatible with " + attrType + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void set" + functionName + "(DmcObject core, " + ad.getType().getName() + " value){\n");
            sb.append("        DmcAttribute<?> attr = get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
            sb.append("        \n");
            sb.append("        try {\n");
            sb.append("            attr.set(value);\n");
            sb.append("            set(core, " + ad.getDMSAGReference() + ",attr);\n");
            sb.append("        } catch (DmcValueException e) {\n");
            sb.append("            throw(new IllegalStateException(\"Type specific modification shouldn't cause an error.\", e));\n");
            sb.append("        }\n");
            sb.append("    }\n\n");
        }
    }

    void formatMVAUX(AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        attrType = attrType + "MV";
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> rem" + functionName + "(DmcObject core){\n");
        sb.append("        if (core == null)\n");
        sb.append("            return(null);\n");
        sb.append("        DmcAttribute<?> rc = core.rem(" + ad.getDMSAGReference() + ");\n");
        sb.append("        removeAuxIfRequired(core);\n");
        sb.append("        return(rc);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("     * @return An Iterator of " + typeName + "REF objects.\n");
            sb.append("     */\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public Iterator<" + typeName + "REF> get" + functionName + "(DmcObject core){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return( ((List<" + typeName + "REF>) Collections.EMPTY_LIST).iterator() );\n");
            sb.append("\n");
            sb.append("        return(attr.getMV());\n");
            sb.append("    }\n\n");
        } else {
            sb.append("     * @return An Iterator of " + typeName + " objects.\n");
            sb.append("     */\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public Iterator<" + typeName + "> get" + functionName + "(DmcObject core){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") get(core, " + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return( ((List<" + typeName + ">) Collections.EMPTY_LIST).iterator() );\n");
            sb.append("\n");
            sb.append("        return(attr.getMV());\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Adds another " + ad.getName() + " value.\n");
        sb.append("     * @param value A value compatible with " + typeName + "\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> add" + functionName + "(DmcObject core, Object value) throws DmcValueException {\n");
        sb.append("        DmcAttribute<?> attr = get(core, " + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            attr = new " + attrType + "(" + ad.getDMSAGReference() + ");\n");
        sb.append("        \n");
        sb.append("        attr.add(value);\n");
        sb.append("        add(core, " + ad.getDMSAGReference() + ",attr);\n");
        sb.append("        return(attr);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * Deletes a " + ad.getName() + " value.\n");
        sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> del" + functionName + "(DmcObject core, Object value) throws DmcValueException {\n");
        sb.append("        return(del(core, " + ad.getDMSAGReference() + ", value));\n");
        sb.append("    }\n\n");
    }
}

