/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.URL;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.enums.OperationalContextEnum;
import org.dmd.dms.util.ComplexTypeFormatter;
import org.dmd.dms.util.DmoActionFormatter;
import org.dmd.dms.util.DmoAttributeFactoryFormatter;
import org.dmd.dms.util.DmoCacheFormatter;
import org.dmd.dms.util.DmoCompactSchemaFormatter;
import org.dmd.dms.util.DmoEnumFormatter;
import org.dmd.dms.util.DmoFormatter;
import org.dmd.dms.util.DmoTypeFormatter;
import org.dmd.dms.util.ExtendedReferenceTypeFormatter;
import org.dmd.dms.util.RuleFormatter;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;

public class DmoGenerator {
    DmoFormatter dmoFormatter;
    DmoCacheFormatter dmoCacheFormatter;
    DmoTypeFormatter typeFormatter;
    DmoEnumFormatter enumFormatter;
    DmoActionFormatter actionFormatter;
    DmoAttributeFactoryFormatter factoryFormatter;
    DmoCompactSchemaFormatter compactSchemaFormatter;
    RuleFormatter ruleFormatter;
    String gendir;
    String dmodir;
    String dsddir;
    String auxdir;
    String typedir;
    String adapterdir;
    String enumdir;
    String ruledir;
    String fileHeader;
    PrintStream progress;

    public DmoGenerator() {
        this.initialize(null);
    }

    public DmoGenerator(PrintStream o) {
        this.initialize(o);
    }

    void initialize(PrintStream o) {
        this.dmoFormatter = new DmoFormatter(o);
        this.dmoCacheFormatter = new DmoCacheFormatter();
        this.typeFormatter = new DmoTypeFormatter(o);
        this.enumFormatter = new DmoEnumFormatter(o);
        this.actionFormatter = new DmoActionFormatter(o);
        this.factoryFormatter = new DmoAttributeFactoryFormatter(o);
        this.compactSchemaFormatter = new DmoCompactSchemaFormatter(o);
        this.ruleFormatter = new RuleFormatter(o);
        this.progress = o;
        this.fileHeader = null;
    }

    public void generateCode(SchemaManager sm, SchemaDefinition sd, ConfigLocation sl) throws IOException, ResultException, DmcNameClashException, IllegalArgumentException, DmcValueException {
        this.gendir = sl.getConfigParentDirectory() + File.separator + "generated";
        this.dmodir = this.gendir + File.separator + "dmo";
        this.dsddir = this.gendir + File.separator + "dsd";
        this.auxdir = this.gendir + File.separator + "dmo";
        this.typedir = this.gendir + File.separator + "types";
        this.adapterdir = this.typedir + File.separator + "adapters";
        this.enumdir = this.gendir + File.separator + "enums";
        this.ruledir = this.gendir + File.separator + "rulesdmo";
        this.fileHeader = null;
        this.createGenDirs(sd);
        this.readFileHeader(sd, sl);
        this.dmoFormatter.setFileHeader(this.fileHeader);
        this.dmoCacheFormatter.setFileHeader(this.fileHeader);
        this.typeFormatter.setFileHeader(this.fileHeader);
        this.enumFormatter.setFileHeader(this.fileHeader);
        this.actionFormatter.setFileHeader(this.fileHeader);
        this.dmoFormatter.dumpDMOs(sm, sd, this.dmodir, this.auxdir);
        this.dmoCacheFormatter.dumpCache(this.dsddir, sl, sd, sm);
        this.typeFormatter.dumpTypes(sd, this.typedir);
        ComplexTypeFormatter.dumpComplexTypes(this.fileHeader, sd, this.typedir);
        ExtendedReferenceTypeFormatter.dumpExtendedReferenceTypes(this.fileHeader, sd, this.typedir);
        this.enumFormatter.dumpEnums(sd, this.enumdir);
        this.actionFormatter.dumpActions(sd, this.dmodir);
        this.compactSchemaFormatter.dumpSchema(sm, sd, this.dmodir);
        this.ruleFormatter.dumpBaseImplementations(sm, sd, this.gendir, OperationalContextEnum.DMO);
    }

    void readFileHeader(SchemaDefinition sd, ConfigLocation sl) throws IOException {
        if (sd.getGeneratedFileHeader() != null) {
            StringBuffer sb = new StringBuffer();
            if (sl.getJarFilename() != null) {
                String str;
                URL url = new URL("jar:file:" + sl.getJarFilename() + "!/" + sl.getJarDirectory() + "/" + sd.getGeneratedFileHeader());
                LineNumberReader in = new LineNumberReader(new InputStreamReader(url.openStream()));
                while ((str = in.readLine()) != null) {
                    sb.append(str + "\n");
                }
                in.close();
            } else {
                String str;
                LineNumberReader in = new LineNumberReader(new FileReader(sl.getDirectory() + File.separator + sd.getGeneratedFileHeader()));
                while ((str = in.readLine()) != null) {
                    sb.append(str + "\n");
                }
                in.close();
            }
            this.fileHeader = sb.toString();
        }
    }

    public void readSchemaFile(URL schema) throws IOException {
        String str;
        System.out.println(schema.getFile());
        LineNumberReader in = new LineNumberReader(new InputStreamReader(schema.openStream()));
        while ((str = in.readLine()) != null) {
            System.out.println(str);
        }
        in.close();
    }

    void createGenDirs(SchemaDefinition sd) {
        File rdf;
        File edf;
        File addf;
        File tdf;
        File adf;
        File dsdf;
        File ddf;
        File gdf = new File(this.gendir);
        if (!gdf.exists()) {
            gdf.mkdir();
        }
        if (!(ddf = new File(this.dmodir)).exists()) {
            ddf.mkdir();
        }
        if (!(dsdf = new File(this.dsddir)).exists()) {
            dsdf.mkdir();
        }
        if (!(adf = new File(this.auxdir)).exists()) {
            adf.mkdir();
        }
        if (!(tdf = new File(this.typedir)).exists()) {
            tdf.mkdir();
        }
        if (!(addf = new File(this.adapterdir)).exists()) {
            addf.mkdir();
        }
        if (!(edf = new File(this.enumdir)).exists()) {
            edf.mkdir();
        }
        if (sd.getRuleDefinitionListSize() > 0 && !(rdf = new File(this.ruledir)).exists()) {
            rdf.mkdir();
        }
    }
}

