/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.util;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.types.DmcTypeClassDefinitionREFMV;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DmoObjectFactoryNew {
    SchemaManager schema;

    public DmoObjectFactoryNew(SchemaManager sm) {
        this.schema = sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcObject createObject(DmcUncheckedObject uco) throws ResultException, DmcValueException, ClassNotFoundException, DmcNameClashException {
        Class<?> dmoClass;
        DmcObject dmo = null;
        AttributeDefinition ad = null;
        ClassDefinition cd = this.schema.cdef(uco.getConstructionClass());
        if (cd == null) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Unknown class: " + uco.getConstructionClass());
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Can't instantiate an ABSTRACT class: " + cd.getDmoImport());
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        try {
            DmoObjectFactoryNew ex = this;
            synchronized (ex) {
                dmoClass = Class.forName(cd.getDmoImport());
            }
        }
        catch (Exception e) {
            ResultException ex = new ResultException();
            ex.result.addResult(4, "Couldn't load Java class: " + cd.getDmoImport());
            ex.result.lastResult().moreMessages(e.getMessage());
            ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
            throw ex;
        }
        try {
            dmo = (DmcObject)dmoClass.newInstance();
        }
        catch (Exception e) {
            ResultException ex = new ResultException();
            ex.result.addResult(4, "Couldn't instantiate Java class: " + cd.getDmoImport());
            ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        DmcTypeClassDefinitionREFMV cref = new DmcTypeClassDefinitionREFMV();
        cref.add(cd.getObjectName());
        for (int i = 1; i < uco.classes.size(); ++i) {
            cd = this.schema.isClass(uco.classes.get(i));
            if (cd == null) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Unknown class: " + uco.classes.get(i));
                throw ex;
            }
            cref.add(cd.getObjectName());
        }
        dmo.add(DmcObject.__objectClass, cref);
        Iterator<String> names = uco.getAttributeNames();
        while (names.hasNext()) {
            String n = names.next();
            ad = this.schema.adef(cd, n);
            if (ad == null) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Unknown attribute: " + n);
                throw ex;
            }
            DmcAttributeInfo ai = dmo.getAttributeInfo(n);
            if (ai == null) {
                ai = ad.getAttributeInfo();
            }
            if (ai == null) {
                throw new IllegalStateException("Unknown attribute id: " + ad.getDmdID() + " for attribute: " + ad.getName());
            }
            NamedStringArray values = null;
            switch (ad.getValueType()) {
                case SINGLE: {
                    values = uco.get(n);
                    try {
                        DmcAttribute<?> attr = dmo.get(ad.getName().getNameString());
                        if (attr == null) {
                            attr = ad.getType().getAttributeHolder(ai);
                        }
                        attr.set(values.get(0));
                        dmo.set(ai, attr);
                        break;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (DmcValueException e) {
                        throw e;
                    }
                }
                case MULTI: 
                case HASHMAPPED: 
                case TREEMAPPED: 
                case HASHSET: 
                case TREESET: {
                    values = uco.get(n);
                    for (String attrVal : values) {
                        try {
                            DmcAttribute<?> attr = dmo.get(ad.getName().getNameString());
                            if (attr == null) {
                                attr = ad.getType().getAttributeHolder(ai);
                            }
                            attr.add(attrVal);
                            dmo.add(ai, attr);
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (DmcValueException e) {
                            throw e;
                        }
                    }
                    break;
                }
            }
        }
        return dmo;
    }
}

